/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.oss.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duibabiz.component.oss.OssClient;
import cn.com.duibabiz.component.oss.OssProperties;
import cn.hutool.core.io.IoUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OssClientImpl
implements OssClient {
    private static final Logger logger = LoggerFactory.getLogger(OssClientImpl.class);
    @Autowired
    private OssProperties ossProperties;

    @Override
    public String upload(String bucketName, String path, File file) throws BizException {
        return this.upload(bucketName, path, file, null, null, null);
    }

    @Override
    public String upload(String bucketName, String path, String base64) throws BizException {
        return this.upload(bucketName, path, null, base64, null, null);
    }

    @Override
    public String upload(String bucketName, String path, InputStream inputStream, String fileName) throws BizException {
        if (StringUtils.isBlank((CharSequence)fileName) || inputStream == null) {
            throw new BizException("\u6587\u4ef6\u540d\u6216\u8005\u6d41\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] split = fileName.split("\\.");
        if (split.length != 2) {
            throw new BizException("\u6587\u4ef6\u540d\u683c\u5f0f\u9519\u8bef");
        }
        return this.upload(bucketName, path, null, null, inputStream, fileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream download(String bucketName, String path) throws BizException {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new BizException("bucketName \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BizException("\u6587\u4ef6\u8def\u5f84 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            String downloadUrl = this.ossProperties.getDownloadUrl();
            downloadUrl = downloadUrl.contains("?") ? downloadUrl + "bucketName=%s&objectName=%s" : downloadUrl + "?bucketName=%s&objectName=%s";
            try {
                String getUrl = String.format(downloadUrl, bucketName, URLEncoder.encode(path, "UTF-8"));
                HttpUtil.download((String)getUrl, (OutputStream)out, (boolean)false);
            }
            catch (Exception e) {
                logger.error("\u4e0b\u8f7d\u9519\u8bef", (Throwable)e);
                throw new BizException("\u4e0b\u8f7d\u9519\u8bef");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException e) {
            logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            throw new BizException("\u7cfb\u7edf\u5f02\u5e38");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream download(String url) throws BizException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try {
                HttpUtil.download((String)URLEncoder.encode(url, "UTF-8"), (OutputStream)out, (boolean)false);
            }
            catch (Exception e) {
                logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                throw new BizException("\u7cfb\u7edf\u5f02\u5e38");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException e) {
            logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            throw new BizException("\u7cfb\u7edf\u5f02\u5e38");
        }
    }

    @Override
    public Boolean fileExist(String bucketName, String path) throws BizException {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new BizException("bucketName \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BizException("\u6587\u4ef6\u8def\u5f84 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String downloadUrl = this.ossProperties.getDownloadUrl();
        downloadUrl = downloadUrl.contains("?") ? downloadUrl + "bucketName=%s&objectName=%s" : downloadUrl + "?bucketName=%s&objectName=%s";
        try {
            String getUrl = String.format(downloadUrl, bucketName, URLEncoder.encode(path, "UTF-8"));
            HttpResponse response = HttpRequest.get((String)getUrl).executeAsync();
            if (!response.isOk() && response.getStatus() == 404) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error("\u7cfb\u7edf\u9519\u8bef", (Throwable)e);
            throw new BizException("\u7cfb\u7edf\u9519\u8bef");
        }
        return true;
    }

    public String upload(String bucketName, String path, File file, String base64, InputStream in, String fileName) throws BizException {
        HttpRequest post = HttpUtil.createPost((String)this.ossProperties.getUploadUrl());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bucketName", bucketName);
        map.put("path", path);
        if (file != null) {
            post.form("file", file);
        }
        if (in != null && StringUtils.isNotBlank((CharSequence)fileName)) {
            post.form("file", IoUtil.readBytes((InputStream)in), fileName);
        }
        if (StringUtils.isNotBlank((CharSequence)base64)) {
            map.put("base64", base64);
        }
        post.form(map);
        post.timeout(5000);
        HttpResponse execute = post.execute();
        try {
            String result = execute.body();
            JSONObject jsonObject = JSON.parseObject((String)result);
            Boolean success = jsonObject.getBoolean("success");
            if (!success.booleanValue()) {
                throw new BizException(jsonObject.getString("message"));
            }
            return jsonObject.getString("data");
        }
        catch (Exception e) {
            logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            throw new BizException("\u7cfb\u7edf\u5f02\u5e38");
        }
    }
}

