package cn.com.duibabiz.component.redis;

import cn.com.duibabiz.component.redis.impl.RedisCustomClientImpl;
import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author sty
 * @Version 1.0
 * @Date 11/20/18 09:51
 **/
@Configuration
@AutoConfigureAfter(RedisAutoConfiguration.class)
@ConditionalOnBean(name = "redisTemplate")
@EnableConfigurationProperties(RedisCustomClientProperties.class)
public class RedisCustomConfiguration {


    @Bean(name = "redisCustomClient")
    public RedisCustomClient redisClient() {
        return new RedisCustomClientImpl();
    }
}
