/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.domain.impl;

import cn.com.duiba.developer.center.api.domain.dto.DomainConfigDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteDomainConfigService;
import cn.com.duibabiz.component.domain.DomainService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainServiceImpl
implements DomainService {
    private static Logger logger = LoggerFactory.getLogger(DomainServiceImpl.class);
    private final RemoteDomainConfigService remoteDomainConfigService;
    private final String serviceDomain;
    private final String tuiaDomain;
    private final String cdnDomain;
    private static final Cache<Long, DomainConfigDto> LOCAL_DOMAIN_CACHE = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).maximumSize(1000L).build();

    public DomainServiceImpl(RemoteDomainConfigService remoteDomainConfigService, String serviceDomain, String tuiaDomain, String cdnDomain) {
        this.remoteDomainConfigService = remoteDomainConfigService;
        this.serviceDomain = serviceDomain;
        this.tuiaDomain = tuiaDomain;
        this.cdnDomain = cdnDomain;
    }

    @Override
    public DomainConfigDto getSystemDomain(Long appId) {
        DomainConfigDto cache;
        DomainConfigDto domainConfigDto = null;
        if (appId == null) {
            appId = -1L;
        }
        if ((cache = this.getCache(appId)) != null) {
            return cache;
        }
        try {
            domainConfigDto = (DomainConfigDto)this.remoteDomainConfigService.findDomainConfig(appId).getResult();
        }
        catch (Exception e) {
            logger.error("\u6839\u636eappid\u67e5\u627e\u57df\u540d\u5931\u8d25{}", (Object)appId, (Object)e);
        }
        if (domainConfigDto == null) {
            domainConfigDto = this.getLocalDomain();
        }
        LOCAL_DOMAIN_CACHE.put((Object)appId, (Object)domainConfigDto);
        return domainConfigDto;
    }

    private DomainConfigDto getLocalDomain() {
        DomainConfigDto domainConfigDto = new DomainConfigDto();
        domainConfigDto.setAppDomain(this.serviceDomain);
        domainConfigDto.setEmbedDomain(this.serviceDomain);
        domainConfigDto.setSeckillDomain(this.serviceDomain);
        domainConfigDto.setGoodsDomain(this.serviceDomain);
        domainConfigDto.setHomeDomain(this.serviceDomain);
        domainConfigDto.setActivityDomain(this.serviceDomain);
        domainConfigDto.setTradeDomain(this.serviceDomain);
        domainConfigDto.setTuiaDomain(this.tuiaDomain);
        domainConfigDto.setCdnDomain(this.cdnDomain);
        return domainConfigDto;
    }

    private DomainConfigDto getCache(Long key) {
        return key != null ? (DomainConfigDto)LOCAL_DOMAIN_CACHE.getIfPresent((Object)key) : null;
    }
}

