package cn.com.duiba.biz.tool.duiba.qpslimit;

import com.google.common.collect.ImmutableSet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

/**
 * 不做限流url解析类
 * Created by zzy on 2018/1/25.
 */
public class ExcludePathHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ExcludePathHelper.class);
    private static Set<String> excludePaths;

    static {
        excludePaths = ImmutableSet.copyOf(parseUrls());
    }

    private ExcludePathHelper() {
    }

    private static Set<String> parseUrls() {
        InputStream inputStream = ExcludePathHelper.class.getClassLoader().getResourceAsStream("META-INF/biz_tool/biz_tool.properties");
        if (inputStream == null) {
            return Collections.emptySet();
        }

        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        } catch (IOException e) {
            LOG.info("failed to load biz_tool.properties", e);
        }
        if (properties.isEmpty()) {
            return Collections.emptySet();
        }
        String value = (String) properties.get("qpslimit.exclude.urls");
        String trimed = StringUtils.trim(value);
        if (StringUtils.isEmpty(trimed)) {
            return Collections.emptySet();
        }
        Set<String> urlSet = new HashSet<>();
        String[] urls = trimed.split(",");
        for (String url : urls) {
            String tempUrl = StringUtils.trim(url);
            if (StringUtils.isEmpty(tempUrl)) {
                continue;
            }
            urlSet.add(tempUrl);
        }
        return urlSet;
    }

    /**
     * 获取qps例外url
     *
     * @return
     */
    public static Set<String> getExcludePaths() {
        return excludePaths;
    }
}
