package cn.com.duiba.biz.tool.duiba.util;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Random;
import cn.com.duiba.wolf.utils.SecurityUtils;

/**
 * token辅助工具类
 * @author sty
 * @Version 1.0
 * @Date 11/16/18 14:43
 **/
public class DuibaTokenUtil {

  private static final Logger LOGGER = LoggerFactory.getLogger(DuibaTokenUtil.class);

  /**
   * 错误的token key，根据该key是取不到对应的token值的
   */
  private static final String ERROR_TOKEN_KEY = "uiiosaidnbua";

  /**
   * 尾部的token key标志，防止纯数字导致某些浏览器无法注入
   */
  private static final String END_OF_TOKEN_KEY = "c";


  /**
   * 根据用户id生成对应的token key
   * @param consumerId
   * @return
   */
  public static String getScrectTokenKey(Long consumerId){

    if(consumerId == null){
      return ERROR_TOKEN_KEY;
    }

    try {
      //防止纯数字，有些浏览器无法直接注入
      String md5 = SecurityUtils.encode2StringByMd5(String.valueOf(consumerId)) + END_OF_TOKEN_KEY;
      return md5.substring(md5.length()-8);
    } catch (Exception e) {
      LOGGER.warn("根据cid生成对应token key md5失败,consumerId={}", consumerId, e);
    }

    return ERROR_TOKEN_KEY;
  }



  public static String genDummyTokenKey() {
    String hash = DigestUtils.md5Hex(String.valueOf(RandomUtils.nextInt(10000000)));
    return hash.substring(hash.length() - 8);
  }

  /**
   * 生成随机的字符串
   */
  private static String getRandomString(int length) {
    //length表示生成字符串的长度
    String base = "abcdefghijklmnopqrstuvwxyz0123456789";
    Random random = new Random();
    StringBuilder sb = new StringBuilder();
    for (int i = 0; i < length; i++) {
      int number = random.nextInt(base.length());
      sb.append(base.charAt(number));
    }
    return sb.toString();
  }

  /**
   * 随机生成token
   * @return
   */
  public static String genToken() {
    int length = RandomUtils.nextInt(5) + 5;
    return getRandomString(length);
  }


}
