package cn.com.duibabiz.component.tokencheck;

import cn.com.duiba.biz.tool.duiba.util.DuibaTokenUtil;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.JavaScriptUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;

import java.util.concurrent.TimeUnit;

/**
 * 本方法为对外提供token能力接口，提供
 * 1.生成token方法
 * 2.校验token方法
 * @author sty
 * @Version 1.0
 * @Date 11/19/18 16:32
 **/
public class TokenCheckService {

  /**
   * 商城用户表单token
   * 一个月过期，或者使用一次后删除
   */
  private static final int MS_FORM_CONSUMER_TOKEN=102;

  /**
   * 测试token
   */
  private static final String TEST_TKEN = "yrJRr7Cddp2YeQd";

  private AdvancedCacheClient advancedCacheClient;
  private String multiDummyToken;

  public TokenCheckService(AdvancedCacheClient advancedCacheClient,String multiDummyToken){
    this.advancedCacheClient = advancedCacheClient;
    this.multiDummyToken = multiDummyToken;
  }


  /**
   * 混淆token.<br>
   * 生成一批假token，把正确的token混淆其中<br>
   *
   * @param count
   * @param key
   * @param value
   * @return
   */
  private String obfuscateToken(int count, String key, String value) {
    StringBuilder stringBuilder = new StringBuilder();
    int index = RandomUtils.nextInt(count);
    for (int i = 0; i < count; i++) {
      stringBuilder.append("window['").append(DuibaTokenUtil.genDummyTokenKey()).append("']=\"").append(DuibaTokenUtil.genToken()).append("\";");
      if (index == i) {
        stringBuilder.append("window['").append(key).append("']=\"").append(value).append("\";");
      }
    }
    // 前端批量生成token js
    if (StringUtils.isNotBlank(multiDummyToken)) {
      stringBuilder.append(multiDummyToken);
    }
    return stringBuilder.toString();
  }

  /**
   * 校验referer
   * @param referer
   * @return
   */
  private boolean passByReferer(String referer) {
    return StringUtils.isNotBlank(referer) && (referer.contains("duiba.com.cn") || !SpringEnvironmentUtils
            .isProdEnv());
  }

  /**
   * 对外提供token方法
   * @param consumerId
   * @param referer
   * @return
   */
  public String getToken(Long consumerId, String referer) {
    if (consumerId == null || !passByReferer(referer)) {
      // referer没有时，提供假token
      String key = DuibaTokenUtil.genDummyTokenKey();
      String token = DuibaTokenUtil.genToken();
      return JavaScriptUtil.obfuscateScript(obfuscateToken(10, key, token));

    } else {
      String token = getConsumerToken(consumerId);
      String key = DuibaTokenUtil.getScrectTokenKey(consumerId);
      return JavaScriptUtil
              .obfuscateScript(obfuscateToken(10, key, token));
    }
  }

  /**
   * 检查token是否正确
   * @param cid
   * @param token
   * @return
   */
  public boolean checkAndInvalidConsumerToken(Long cid, String token) {
//    if (SpringEnvironmentUtils.isDevEnv()) {
//      return true;
//    }
    if (token == null) {
      return false;
    }
    // 如果是测试的token，那么默认可用
    if (TEST_TKEN.equals(token)) {
      return true;
    }
    String key = getConsumerKey(cid);
    String memToken = advancedCacheClient.get(key);
    if (memToken == null) {
      return false;
    }
    advancedCacheClient.remove(key);
    return memToken.equals(token);
  }


  /**
   * 直接从redis获取token
   *
   * @param cid
   * @return
   */
  private String getConsumerToken(Long cid) {
    String key = getConsumerKey(cid);
    String token = advancedCacheClient.get(key);
    if (token == null) {
      token = DuibaTokenUtil.genToken();
      advancedCacheClient.set(key, token, 15, TimeUnit.MINUTES);
    }
    return token;
  }


  private String getConsumerKey(Long cid) {
    return MS_FORM_CONSUMER_TOKEN + "-" + cid;
  }


}
