package cn.com.duibabiz.component.tokencheck;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

import javax.annotation.Resource;

import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author sty
 * @Version 1.0
 * @Date 11/20/18 09:51
 **/
@Configuration
@ConditionalOnProperty(name = "duiba.biztool.token.enable", havingValue = "true")
@AutoConfigureAfter(RedisAutoConfiguration.class)
@ConditionalOnClass({AdvancedCacheClient.class})
@ConditionalOnBean(name = "redisTemplate")
@EnableConfigurationProperties(DuibaTokenJsProperties.class)
public class TokenConfiguration {

	@Resource(name = "redisTemplate")
	private AdvancedCacheClient advancedCacheClient;
	@Autowired
	private DuibaTokenJsProperties duibaTokenJsProperties;

	@Bean(name = "tokenCheckService")
	public TokenCheckService tokenCheckService() {
		if (advancedCacheClient == null) {
			throw new IllegalArgumentException("advancedCacheClient注入失败");
		}
		return new TokenCheckService(advancedCacheClient, duibaTokenJsProperties.getToken());

	}


}
