package cn.com.duibabiz.component.versioncheck;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * Created by sunchangji on 2018/12/3.
 */
@Order(-1)
public class BizBannerVersionRunListener implements SpringApplicationRunListener {
	private SpringApplication application;
	/**
	 * 必须有这个构造函数，否则spring无法初始化该类
	 * @param application
	 * @param args
	 */
	public BizBannerVersionRunListener(SpringApplication application, String[] args) {
		this.application = application;
	}

	@Override
	public void starting() {
		System.out.println("BizBannerVersionRunListener 执行....");
		setBizVersion();
	}

	@Override
	public void environmentPrepared(ConfigurableEnvironment configurableEnvironment) {
		setBizVersion();
	}

	@Override
	public void contextPrepared(ConfigurableApplicationContext configurableApplicationContext) {
		setBizVersion();
	}

	@Override
	public void contextLoaded(ConfigurableApplicationContext configurableApplicationContext) {

	}

	@Override
	public void finished(ConfigurableApplicationContext configurableApplicationContext, Throwable throwable) {

	}


	private void setBizVersion(){
		String version = BizToolVersion.getVersion();
		if(version == null){
			return;
		}
		System.setProperty("banner.extra.info", " :: Biz tool :: (v" + version + ")");
	}
}
