/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.tokencheck;

import cn.com.duiba.biz.tool.duiba.util.DuibaTokenUtil;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.JavaScriptUtil;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;

public class TokenCheckService {
    private static final int MS_FORM_CONSUMER_TOKEN = 102;
    private static final String TEST_TKEN = "yrJRr7Cddp2YeQd";
    private AdvancedCacheClient advancedCacheClient;
    private String multiDummyToken;

    public TokenCheckService(AdvancedCacheClient advancedCacheClient, String multiDummyToken) {
        this.advancedCacheClient = advancedCacheClient;
        this.multiDummyToken = multiDummyToken;
    }

    private String obfuscateToken(int count, String key, String value) {
        StringBuilder stringBuilder = new StringBuilder();
        int index = RandomUtils.nextInt((int)count);
        for (int i = 0; i < count; ++i) {
            stringBuilder.append("window['").append(DuibaTokenUtil.genDummyTokenKey()).append("']=\"").append(DuibaTokenUtil.genToken()).append("\";");
            if (index != i) continue;
            stringBuilder.append("window['").append(key).append("']=\"").append(value).append("\";");
        }
        if (StringUtils.isNotBlank((String)this.multiDummyToken)) {
            stringBuilder.append(this.multiDummyToken);
        }
        return stringBuilder.toString();
    }

    private boolean passByReferer(String referer) {
        return StringUtils.isNotBlank((String)referer) && (referer.contains("duiba.com.cn") || !SpringEnvironmentUtils.isProdEnv());
    }

    public String getToken(Long consumerId, String referer) {
        if (consumerId == null || !this.passByReferer(referer)) {
            String key = DuibaTokenUtil.genDummyTokenKey();
            String token = DuibaTokenUtil.genToken();
            return JavaScriptUtil.obfuscateScript((CharSequence)this.obfuscateToken(10, key, token));
        }
        String token = this.getConsumerToken(consumerId);
        String key = DuibaTokenUtil.getScrectTokenKey(consumerId);
        return JavaScriptUtil.obfuscateScript((CharSequence)this.obfuscateToken(10, key, token));
    }

    public boolean checkAndInvalidConsumerToken(Long cid, String token) {
        if (token == null) {
            return false;
        }
        if (TEST_TKEN.equals(token)) {
            return true;
        }
        String key = this.getConsumerKey(cid);
        String memToken = (String)this.advancedCacheClient.get(key);
        if (memToken == null) {
            return false;
        }
        this.advancedCacheClient.remove(key);
        return memToken.equals(token);
    }

    private String getConsumerToken(Long cid) {
        String key = this.getConsumerKey(cid);
        String token = (String)this.advancedCacheClient.get(key);
        if (token == null) {
            token = DuibaTokenUtil.genToken();
            this.advancedCacheClient.set(key, (Object)token, 15, TimeUnit.MINUTES);
        }
        return token;
    }

    private String getConsumerKey(Long cid) {
        return "102-" + cid;
    }
}

