/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.tokencheck.impl;

import cn.com.duiba.biz.tool.duiba.util.DuibaTokenUtil;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.JavaScriptUtil;
import cn.com.duibabiz.component.tokencheck.TokenCheckService;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TokenCheckServiceImpl
implements TokenCheckService {
    private static final Logger LOGGER;
    private static final String MULTI_DUMMY_TOKEN;
    public static final int MS_FORM_CONSUMER_TOKEN = 102;
    private static final String TEST_TKEN = "yrJRr7Cddp2YeQd";
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;

    private String obfuscateToken(int count, String key, String value) {
        StringBuilder stringBuilder = new StringBuilder();
        int index = RandomUtils.nextInt((int)count);
        for (int i = 0; i < count; ++i) {
            stringBuilder.append("window['").append(DuibaTokenUtil.genDummyTokenKey()).append("']=\"").append(DuibaTokenUtil.genToken()).append("\";");
            if (index != i) continue;
            stringBuilder.append("window['").append(key).append("']=\"").append(value).append("\";");
        }
        if (StringUtils.isNotBlank((String)MULTI_DUMMY_TOKEN)) {
            stringBuilder.append(MULTI_DUMMY_TOKEN);
        }
        return stringBuilder.toString();
    }

    private boolean passByReferer(String referer) {
        return StringUtils.isNotBlank((String)referer) && (referer.contains("duiba.com.cn") || !SpringEnvironmentUtils.isProdEnv());
    }

    @Override
    public String getToken(Long consumerId, String referer) {
        if (consumerId == null || !this.passByReferer(referer)) {
            String key = DuibaTokenUtil.genDummyTokenKey();
            String token = DuibaTokenUtil.genToken();
            return JavaScriptUtil.obfuscateScript((CharSequence)this.obfuscateToken(10, key, token));
        }
        String token = this.getConsumerToken(consumerId);
        String key = DuibaTokenUtil.getScrectTokenKey(consumerId);
        return JavaScriptUtil.obfuscateScript((CharSequence)this.obfuscateToken(10, key, token));
    }

    @Override
    public boolean checkAndInvalidConsumerToken(Long cid, String token) {
        if (token == null) {
            return false;
        }
        if (TEST_TKEN.equals(token)) {
            return true;
        }
        String key = this.getConsumerKey(cid);
        String memToken = (String)this.advancedCacheClient.get(key);
        if (memToken == null) {
            return false;
        }
        this.advancedCacheClient.remove(key);
        return memToken.equals(token);
    }

    private String getConsumerToken(Long cid) {
        String key = this.getConsumerKey(cid);
        String token = (String)this.advancedCacheClient.get(key);
        if (token == null) {
            token = DuibaTokenUtil.genToken();
            this.advancedCacheClient.set(key, (Object)token, 15, TimeUnit.MINUTES);
        }
        return token;
    }

    private String getConsumerKey(Long cid) {
        return "102-" + cid;
    }

    static {
        String content;
        LOGGER = LoggerFactory.getLogger(TokenCheckService.class);
        try (InputStream is = DuibaTokenUtil.class.getClassLoader().getResourceAsStream("dummy_token.js");){
            content = IOUtils.toString((InputStream)is, (String)"utf-8");
        }
        catch (Exception e) {
            LOGGER.warn("token\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("token\u521d\u59cb\u5316\u5931\u8d25");
        }
        MULTI_DUMMY_TOKEN = content;
    }
}

