package cn.com.duibabiz.component.domain;

import cn.com.duibabiz.component.domain.impl.DomainServiceImpl;
import cn.com.duiba.developer.center.api.remoteservice.RemoteDomainConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by zzy on  2018/09/28 21:18
 */
@ConditionalOnProperty(value = "duiba.domain.service.enable", havingValue = "true")
@ConditionalOnClass(value = RemoteDomainConfigService.class)
@Configuration
public class DomainAutoConfig {
    @Autowired
    private RemoteDomainConfigService remoteDomainConfigService;
    @Value("${duiba.service.domain://activity.m.duiba.com.cn}")
    private String serviceDomain;

    @Value("${duiba.tuia.domain://activity.tuistone.com}")
    private String tuiaDomain;

    @Value("${duiba.cdn.domain://yun.duiba.com.cn}")
    private String cdnDomain;

    @Value("${spring.profiles.active:prodvpc}")
    private String env;

    @Bean(name = "domainService")
    public DomainService domainService() {
        DomainService domainService = new DomainServiceImpl(remoteDomainConfigService, serviceDomain, tuiaDomain, cdnDomain);
        return domainService;
    }

    @ConditionalOnProperty(name = "duiba.domain.rspbody.handle.enable", havingValue = "true")
    @Bean
    public ResponseBodyDomainHander responseBodyDomainHander() {
        return new ResponseBodyDomainHander(domainService(), env);
    }
}
