package cn.com.duibabiz.component.tokencheck;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;


/**
 * 类初始化加载放入spring容器
 * @author sty
 * @Version 1.0
 * @Date 11/20/18 10:06
 **/
public class TokenRegistryProcessor implements BeanDefinitionRegistryPostProcessor {

  @Override
  public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry)
      throws BeansException {
    BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(TokenCheckService.class);
    registry.registerBeanDefinition("tokenService", builder.getBeanDefinition());
  }

  @Override
  public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory)
      throws BeansException {

  }
}
