/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.token.impl;

import cn.com.duiba.biz.tool.duiba.util.DuibaTokenUtil;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.JavaScriptUtil;
import cn.com.duibabiz.component.token.TokenService;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.springframework.util.Assert;

public class TokenServiceImpl
implements TokenService {
    private final AdvancedCacheClient advancedCacheClient;
    private final String multiDummyTokenJs;
    private static final String ONLINE_DOMAIN_MARK = "duiba.com.cn";
    private static final int MS_FORM_CONSUMER_TOKEN = 102;
    private static final int SECRET_TOKEN_CACHE_MINUTES = 5;
    private static final int OBFUSCATE_TOKEN_COUNT = 10;
    private static final String TEST_TOKEN = "yrJRr7Cddp2YeQd";

    public TokenServiceImpl(AdvancedCacheClient advancedCacheClient, String multiDummyTokenJs) {
        this.advancedCacheClient = advancedCacheClient;
        this.multiDummyTokenJs = multiDummyTokenJs;
    }

    @Override
    public String getAndCacheSecretToken(Long consumerId) {
        Assert.notNull((Object)consumerId, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        return this.getAndCacheSecretToken(this.getSecretTokenCacheKey(consumerId));
    }

    @Override
    public String getAndCacheSecretToken(String customizedCacheKey) {
        Assert.notNull((Object)customizedCacheKey, (String)"\u5b9a\u5236\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a");
        return (String)this.advancedCacheClient.getWithCacheLoader(customizedCacheKey, 5, TimeUnit.MINUTES, false, DuibaTokenUtil::genToken);
    }

    @Override
    public String getConfusedToken(Long consumerId, String referer) {
        return this.getConfusedToken(consumerId, referer, consumerId != null ? this.getSecretTokenCacheKey(consumerId) : null);
    }

    @Override
    public String getConfusedToken(Long consumerId, String referer, String customizedCacheKey) {
        String token;
        String key;
        if (consumerId == null || !TokenServiceImpl.passByReferer(referer)) {
            key = DuibaTokenUtil.genDummyTokenKey();
            token = DuibaTokenUtil.genToken();
        } else {
            key = DuibaTokenUtil.getSecretTokenKey(consumerId);
            token = this.getAndCacheSecretToken(customizedCacheKey);
        }
        return JavaScriptUtil.obfuscateScript((CharSequence)this.obfuscateToken(10, key, token));
    }

    @Override
    public boolean checkAndInvalidConsumerToken(Long consumerId, String token) {
        if (consumerId == null || StringUtils.isBlank((String)token)) {
            return false;
        }
        return this.checkAndInvalidConsumerToken(this.getSecretTokenCacheKey(consumerId), token);
    }

    @Override
    public boolean checkAndInvalidConsumerToken(String customizedCacheKey, String token) {
        if (StringUtils.isBlank((String)customizedCacheKey) || StringUtils.isBlank((String)token)) {
            return false;
        }
        if (TEST_TOKEN.equals(token)) {
            return true;
        }
        String cacheToken = (String)this.advancedCacheClient.get(customizedCacheKey);
        if (StringUtils.isBlank((String)cacheToken)) {
            return false;
        }
        this.advancedCacheClient.remove(customizedCacheKey);
        return cacheToken.equals(token);
    }

    private String obfuscateToken(int count, String key, String token) {
        StringBuilder sb = new StringBuilder();
        int keyRandomIndex = RandomUtils.nextInt((int)count);
        IntStream.range(0, count).forEach(i -> {
            sb.append("window['").append(DuibaTokenUtil.genDummyTokenKey()).append("']=\"").append(DuibaTokenUtil.genToken()).append("\";");
            if (keyRandomIndex == i) {
                sb.append("window['").append(key).append("']=\"").append(token).append("\";");
            }
        });
        if (StringUtils.isNotBlank((String)this.multiDummyTokenJs)) {
            sb.append(this.multiDummyTokenJs);
        }
        return sb.toString();
    }

    private String getSecretTokenCacheKey(Long consumerId) {
        return "102-" + consumerId;
    }

    private static boolean passByReferer(String referer) {
        return StringUtils.isNotBlank((String)referer) && (referer.contains(ONLINE_DOMAIN_MARK) || !SpringEnvironmentUtils.isProdEnv());
    }
}

