package cn.com.duibabiz.component.email;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

import javax.mail.internet.MimeMessage;
import java.util.List;

/**
 * Created by sunchangji on 2019/3/11.
 */
public class DuibaEmailHelper {
	private static final Logger LOG = LoggerFactory.getLogger(DuibaEmailHelper.class);

	@Autowired
	private JavaMailSender sender;
	@Autowired
	private DuibaEmailProperties duibaEmailProperties;

	/**
	 * 发送邮件方法
	 *
	 * @param emailBean 邮件内容设置
	 * @return
	 */
	public boolean sendEmail(DuibaSendEmailBean emailBean) {
		List<String> toUsers = emailBean.getToUsers();
		if (CollectionUtils.isEmpty(toUsers)) {
			throw new IllegalArgumentException("接受人的邮箱地址必填");
		}
		try {
			MimeMessage mail = sender.createMimeMessage();
			MimeMessageHelper helper = new MimeMessageHelper(mail);
			helper.setTo(toUsers.toArray(new String[toUsers.size()]));
			helper.setSubject(emailBean.getSubject());
			helper.setFrom(duibaEmailProperties.getUsername());
			helper.setText(emailBean.getContent(), emailBean.getIsHtml());
			sender.send(mail);
			return true;
		} catch (Exception e) {
			LOG.error("邮件发送异常,emailBean={}", JSONObject.toJSONString(emailBean), e);
			return false;
		}
	}

}
