package cn.com.duibabiz.component.filters;

import cn.com.duibaboot.ext.autoconfigure.accesslog.AccessLogFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;

/**
 * Created by sunchangji on 2019/4/16.
 */
public class DuibaHostFilter implements Filter {

	@Autowired
	private DuibaHostConfig duibaHostConfig;

	private static final Logger LOG = LoggerFactory.getLogger(DuibaHostFilter.class);

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
		//do nothing
	}

	@Override
	public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
		try {
			filterChain.doFilter(servletRequest, servletResponse);
		} finally {
			String host = null;
			try {
				HttpServletRequest request = (HttpServletRequest) servletRequest;
				host = request.getHeader(AccessLogFilter.OW_HOST);
				replaceAccessLogHost(host);
			} catch (Exception e) {
				LOG.error("DuibaHostFilter process error, host={},message={}", host, e.getMessage());
			}
		}
	}

	private void replaceAccessLogHost(String host) {
		if (host == null) {
			LOG.info("DuibaHostFilter host is null");
			return;
		}
		List<String> fromDomains = duibaHostConfig.getFromDomains();
		for (String fromDomain : fromDomains) {
			if(StringUtils.isBlank(fromDomain)){
				continue;
			}

			if (host.endsWith(fromDomain.trim())) {
				AccessLogFilter.putOverWritePair(AccessLogFilter.OW_HOST, duibaHostConfig.getToDomain());
				return;
			}
		}
	}

	@Override
	public void destroy() {
		//do nothing
	}
}
