package cn.com.duibabiz.component.oss;

import cn.com.duiba.boot.exception.BizException;

import java.io.File;
import java.io.InputStream;

public interface OssClient {

    /**
     * 普通上传
     * @param bucketName 非必填 不填默认使用统一配置
     * @param path 路径 非必填 路径不能以/ 开头 例如 a/b/c.png
     * @param file 文件 必填
     * @return 成功则返回 url 失败则抛出异常
     * @throws BizException
     */
    String upload(String bucketName, String path, File file) throws BizException;

    /**
     * 普通上传
     * @param bucketName 非必填 不填默认使用统一配置
     * @param path 路径 非必填 路径不能以/ 开头 例如 a/b/c.png
     * @param base64 文件的base64 必填
     * @return 成功则返回 url 失败则抛出异常
     * @throws BizException
     */
    String upload(String bucketName, String path, String base64) throws BizException;

    /**
     * 普通上传
     * @param bucketName 非必填 不填默认使用统一配置
     * @param path 路径 非必填 路径不能以/ 开头  例如 a/b/c.png
     * @param inputStream 文件流 必填
     * @param fileName 文件名带后缀 必填
     * @return 成功则返回 url 失败则抛出异常
     * @throws BizException
     */
    String upload(String bucketName, String path, InputStream inputStream,String fileName) throws BizException;

    /**
     * 追加上传
     * @param bucketName 非必填 不填默认使用统一配置
     * @param path 路径 非必填 路径不能以/ 开头  例如 a/b/c.png 当追加的不是一个新文件的时候必传
     * @param inputStream 文件流 必填
     * @param fileName 文件名带后缀 必填
     * @param position 追加的位置 必填
     * @return 成功则返回 位置/文件名 失败则抛出异常
     * @throws BizException
     */
    OssAppendEntity appendUpload(String bucketName, String path, InputStream inputStream,String fileName,Long position) throws BizException;


    /**
     * 普通下载
     * @param bucketName 非必填 不填默认使用统一配置
     * @param path 路径 必填 路径不能以/ 开头
     * @return 成功则返回 流 失败则抛出异常
     * @throws BizException
     */
    InputStream download(String bucketName, String path) throws BizException;


    /**
     * 普通下载
     * @param url 必填
     * @return 成功则返回 流 失败则抛出异常
     * @throws BizException
     */
    InputStream download(String url) throws BizException;

    /**
     * 判断文件是否存在
     * @param bucketName 非必填 不填默认使用统一配置
     * @param path 路径 必填 路径不能以/ 开头
     * @return 成功则返回 流 失败则抛出异常
     * @throws BizException
     */
    Boolean fileExist(String bucketName, String path) throws BizException;


}
