package cn.com.duibabiz.component.oss;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author XuJing
 * @since 2020/5/14 10:09 上午
 */
@ConfigurationProperties(prefix = "duiba.oss")
public class OssProperties {

    /**
     * 普通上传url
     */
    private String uploadUrl;

    /**
     * 追加上传url
     */
    private String appendUploadUrl;

    /**
     * 普通下载url
     */
    private String downloadUrl;

    /**
     * 命名空间
     */
    private String bucketName;


    public static final String devUploadUrl = "http://10.254.221.188:1031/oss/upload";
    public static final String testUploadUrl = "http://10.114.5.156:1031/oss/upload";
    public static final String preUploadUrl = "http://10.214.89.193:1031/oss/upload";
    public static final String prodUploadUrl = "http://10.216.204.242:1031/oss/upload";

    public static final String devAppendUploadUrl = "http://10.254.221.188:1031/oss/uploadAppend";
    public static final String testAppendUploadUrl = "http://10.114.5.156:1031/oss/uploadAppend";
    public static final String preAppendUploadUrl = "http://10.214.89.193:1031/oss/uploadAppend";
    public static final String prodAppendUploadUrl = "http://10.216.204.242:1031/oss/uploadAppend";

    public static final String devDownloadUrl = "http://10.254.221.188:1031/oss/download";
    public static final String testDownloadUrl = "http://10.114.5.156:1031/oss/download";
    public static final String preDownloadUrl = "http://10.214.89.193:1031/oss/download";
    public static final String prodDownloadUrl = "http://10.216.204.242:1031/oss/download";

    public static final String devBuckName = "daily-duiba";
    public static final String testBuckName = "daily-duiba";
    public static final String preBuckName = "duiba";
    public static final String prodBuckName = "duiba";


    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setAppendUploadUrl(String appendUploadUrl) {
        this.appendUploadUrl = appendUploadUrl;
    }

    public String getBucketName() throws BizException {
        if (StringUtils.isNotBlank(bucketName)) {
            return bucketName;
        }
        if (SpringEnvironmentUtils.isDevEnv()) {
            return OssProperties.devBuckName;
        }
        if (SpringEnvironmentUtils.isTestEnv()) {
            return OssProperties.testBuckName;
        }
        if (SpringEnvironmentUtils.isPreEnv()) {
            return OssProperties.preBuckName;
        }
        if (SpringEnvironmentUtils.isProdEnv()) {
            return OssProperties.prodBuckName;
        }
        throw new BizException("请检查bucketName");
    }

    public String getUploadUrl() throws BizException {
        if (StringUtils.isNotBlank(uploadUrl)) {
            return uploadUrl;
        }
        if (SpringEnvironmentUtils.isDevEnv()) {
            return OssProperties.devUploadUrl;
        }
        if (SpringEnvironmentUtils.isTestEnv()) {
            return OssProperties.testUploadUrl;
        }
        if (SpringEnvironmentUtils.isPreEnv()) {
            return OssProperties.preUploadUrl;
        }
        if (SpringEnvironmentUtils.isProdEnv()) {
            return OssProperties.prodUploadUrl;
        }
        throw new BizException("请检查上传配置地址");
    }

    public String getDownloadUrl() throws BizException {
        if (StringUtils.isNotBlank(downloadUrl)) {
            return downloadUrl;
        }
        if (SpringEnvironmentUtils.isDevEnv()) {
            return OssProperties.devDownloadUrl;
        }
        if (SpringEnvironmentUtils.isTestEnv()) {
            return OssProperties.testDownloadUrl;
        }
        if (SpringEnvironmentUtils.isPreEnv()) {
            return OssProperties.preDownloadUrl;
        }
        if (SpringEnvironmentUtils.isProdEnv()) {
            return OssProperties.prodDownloadUrl;
        }
        throw new BizException("请检查下载配置地址");
    }

    public String getAppendUploadUrl() throws BizException {
        if (StringUtils.isNotBlank(appendUploadUrl)) {
            return appendUploadUrl;
        }
        if (SpringEnvironmentUtils.isDevEnv()) {
            return OssProperties.devAppendUploadUrl;
        }
        if (SpringEnvironmentUtils.isTestEnv()) {
            return OssProperties.testAppendUploadUrl;
        }
        if (SpringEnvironmentUtils.isPreEnv()) {
            return OssProperties.preAppendUploadUrl;
        }
        if (SpringEnvironmentUtils.isProdEnv()) {
            return OssProperties.prodAppendUploadUrl;
        }
        throw new BizException("请检查下载配置地址");
    }


}
