/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.oss.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duibabiz.component.oss.OssAppendEntity;
import cn.com.duibabiz.component.oss.OssClient;
import cn.com.duibabiz.component.oss.OssProperties;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OssClientImpl
implements OssClient {
    private static final Logger logger = LoggerFactory.getLogger(OssClientImpl.class);
    @Autowired
    private OssProperties ossProperties;
    @Resource(name="ossHttpClient")
    @CanAccessInsideNetwork
    private CloseableHttpClient httpClient;

    @Override
    public String upload(String bucketName, String path, File file) throws BizException {
        return this.upload(bucketName, path, file, null, null, null);
    }

    @Override
    public String upload(String bucketName, String path, String base64) throws BizException {
        return this.upload(bucketName, path, null, base64, null, null);
    }

    @Override
    public String upload(String bucketName, String path, InputStream inputStream, String fileName) throws BizException {
        if (StringUtils.isBlank((CharSequence)fileName) || inputStream == null) {
            throw new BizException("\u6587\u4ef6\u540d\u6216\u8005\u6d41\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] split = fileName.split("\\.");
        if (split.length != 2) {
            throw new BizException("\u6587\u4ef6\u540d\u683c\u5f0f\u9519\u8bef");
        }
        return this.upload(bucketName, path, null, null, inputStream, fileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OssAppendEntity appendUpload(String bucketName, String path, InputStream inputStream, String fileName, Long position) throws BizException {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossProperties.getBucketName();
        }
        if (inputStream == null) throw new BizException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        if (position == null) throw new BizException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new BizException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (position.equals(0L) && StringUtils.isBlank((CharSequence)path)) {
            throw new BizException("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] split = fileName.split("\\.");
        if (split.length != 2) {
            throw new BizException("\u6587\u4ef6\u540d\u683c\u5f0f\u9519\u8bef");
        }
        HttpPost httpPost = new HttpPost(this.ossProperties.getAppendUploadUrl());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addPart("bucketName", (ContentBody)new StringBody(bucketName, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
        builder.addPart("position", (ContentBody)new StringBody(position.toString(), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
        builder.addBinaryBody("file", inputStream, ContentType.DEFAULT_BINARY, fileName);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            builder.addPart("path", (ContentBody)new StringBody(path, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
        }
        HttpEntity reqEntity = builder.build();
        httpPost.setEntity(reqEntity);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            JSONObject jsonObject = JSON.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()));
            if (jsonObject.getBoolean("success").booleanValue()) {
                OssAppendEntity ossAppendEntity = (OssAppendEntity)JSON.parseObject((String)jsonObject.getJSONObject("data").toJSONString(), OssAppendEntity.class);
                return ossAppendEntity;
            }
            throw new BizException(jsonObject.getString("message"));
        }
        catch (Exception e) {
            logger.error("\u7cfb\u7edf\u5f02\u5e38 bucketName={},path={},fileName={}", new Object[]{bucketName, path, fileName, e});
            throw new BizException("\u8ffd\u52a0\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @Override
    public InputStream download(String bucketName, String path) throws BizException {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossProperties.getBucketName();
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BizException("\u6587\u4ef6\u8def\u5f84 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String downloadUrl = this.ossProperties.getDownloadUrl();
        downloadUrl = downloadUrl.contains("?") ? downloadUrl + "bucketName=%s&objectName=%s" : downloadUrl + "?bucketName=%s&objectName=%s";
        String getUrl = String.format(downloadUrl, bucketName, path);
        return this.httpDownload(getUrl);
    }

    @Override
    public InputStream download(String url) throws BizException {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new BizException("url \u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.httpDownload(url);
    }

    @Override
    public Boolean fileExist(String bucketName, String path) throws BizException {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossProperties.getBucketName();
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BizException("\u6587\u4ef6\u8def\u5f84 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String downloadUrl = this.ossProperties.getDownloadUrl();
        downloadUrl = downloadUrl.contains("?") ? downloadUrl + "bucketName=%s&objectName=%s" : downloadUrl + "?bucketName=%s&objectName=%s";
        try {
            String getUrl = String.format(downloadUrl, bucketName, path);
            this.httpDownload(getUrl);
            return true;
        }
        catch (BizException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream httpDownload(String url) throws BizException {
        HttpGet get = new HttpGet(url);
        get.setHeader("Accept-Language", "zh-cn,zh;q=0.5");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
            if (response.getStatusLine().getStatusCode() != 200) throw new BizException("\u4e0b\u8f7d\u9519\u8bef");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.inputStream2byte(response.getEntity().getContent()));
            return byteArrayInputStream;
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u9519\u8bef url={}", (Object)url, (Object)e);
        }
        throw new BizException("\u4e0b\u8f7d\u9519\u8bef");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String upload(String bucketName, String path, File file, String base64, InputStream in, String fileName) throws BizException {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossProperties.getBucketName();
        }
        try {
            HttpPost httpPost = new HttpPost(this.ossProperties.getUploadUrl());
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addPart("bucketName", (ContentBody)new StringBody(bucketName, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
            if (StringUtils.isNotBlank((CharSequence)path)) {
                builder.addPart("path", (ContentBody)new StringBody(path, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
            }
            if (file != null) {
                builder.addBinaryBody("file", (InputStream)new FileInputStream(file), ContentType.DEFAULT_BINARY, file.getName());
            }
            if (in != null && StringUtils.isNotBlank((CharSequence)fileName)) {
                builder.addBinaryBody("file", in, ContentType.DEFAULT_BINARY, fileName);
            }
            if (StringUtils.isNotBlank((CharSequence)base64)) {
                builder.addPart("base64", (ContentBody)new StringBody(base64, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
            }
            HttpEntity reqEntity = builder.build();
            httpPost.setEntity(reqEntity);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new BizException("\u7cfb\u7edf\u5f02\u5e38");
                }
                JSONObject jsonObject = JSON.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()));
                Boolean success = jsonObject.getBoolean("success");
                if (!success.booleanValue()) {
                    throw new BizException(jsonObject.getString("message"));
                }
                String string = jsonObject.getString("data");
                return string;
            }
        }
        catch (Exception e) {
            logger.error("\u7cfb\u7edf\u5f02\u5e38 bucketName={},path={},fileName={}", new Object[]{bucketName, path, file == null ? fileName : file.getName(), e});
            throw new BizException("\u7cfb\u7edf\u5f02\u5e38");
        }
    }

    public byte[] inputStream2byte(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        while ((rc = inputStream.read(buff, 0, 100)) > 0) {
            byteArrayOutputStream.write(buff, 0, rc);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

