/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.actionevent;

import cn.com.duibabiz.component.actionevent.UserActionEventNotifyDto;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class UserActionEventMQProducer
implements ApplicationContextAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserActionEventMQProducer.class);
    public static final String DUIBA_USEREVENT_NOTIFY_TAG = "duiba-userevent-notify";
    private ApplicationContext applicationContext;
    private static DefaultMQProducer rocketMqProducer;

    public void sendMsg(UserActionEventNotifyDto userActionEventNotifyDto, String userEventNotifyTopic) {
        this.sendMsg(userActionEventNotifyDto, userEventNotifyTopic, DUIBA_USEREVENT_NOTIFY_TAG);
    }

    private void sendMsg(UserActionEventNotifyDto userActionEventNotifyDto, String userEventNotifyTopic, String tag) {
        try {
            String info = JSONObject.toJSONString((Object)userActionEventNotifyDto);
            byte[] body = info.getBytes(Charset.forName("utf-8"));
            Message message = new Message(userEventNotifyTopic, tag, body);
            SendResult sendResult = rocketMqProducer.send(message);
            if (sendResult.getSendStatus() != SendStatus.SEND_OK) {
                LOGGER.error("\u53d1\u9001\u7528\u6237\u884c\u4e3a\u4e8b\u4ef6\u5931\u8d25,msg={}", (Object)info);
            } else {
                LOGGER.info("\u53d1\u9001\u7528\u6237\u884c\u4e3a\u4e8b\u4ef6\u6210\u529f,msg={}", (Object)info);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001\u7528\u6237\u884c\u4e3a\u4e8b\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        DefaultMQProducer rocketMqProducer = (DefaultMQProducer)this.applicationContext.getBean(DefaultMQProducer.class);
        if (rocketMqProducer == null) {
            throw new IllegalStateException("there must exists a bean of class DefaultMQProducer(in spring-boot-starter-rocketmq)");
        }
        UserActionEventMQProducer.rocketMqProducer = rocketMqProducer;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

