/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.domain;

import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duiba.developer.center.api.domain.dto.DomainConfigDto;
import cn.com.duibabiz.component.domain.DomainService;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseBodyDomainHander
implements ResponseBodyAdvice<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseBodyDomainHander.class);
    private static final String ACTIVITY_DOMAIN_PROD = "//activity.m.duiba.com.cn";
    private static final String HOME_DOMAIN_PROD = "//home.m.duiba.com.cn";
    private static final String TRADE_DOMAIN_PROD = "//trade.m.duiba.com.cn";
    private static final String GOODS_DOMAIN_PROD = "//goods.m.duiba.com.cn";
    private static final String SECKILL_DOMAIN_PROD = "//seckill.duiba.com.cn";
    private static final String EMBED_DOMAIN_PROD = "//embedlog.duiba.com.cn";
    private static final String CDN_DOMAIN_PROD = "//yun.duiba.com.cn";
    private static final String ACTIVITY_DOMAIN_TEST = "//activity.m.duibatest.com.cn";
    private static final String HOME_DOMAIN_TEST = "//home.m.duibatest.com.cn";
    private static final String TRADE_DOMAIN_TEST = "//trade.m.duibatest.com.cn";
    private static final String GOODS_DOMAIN_TEST = "//goods.m.duibatest.com.cn";
    private static final String SECKILL_DOMAIN_TEST = "//seckill.duibatest.com.cn";
    private static final String EMBED_DOMAIN_TEST = "//embedlog.duibatest.com.cn";
    private static final String ACTIVITY_DOMAIN_DEV = "//activity.m.duibadev.com.cn";
    private static final String HOME_DOMAIN_DEV = "//home.m.duibadev.com.cn";
    private static final String TRADE_DOMAIN_DEV = "//trade.m.duibadev.com.cn";
    private static final String GOODS_DOMAIN_DEV = "//goods.m.duibadev.com.cn";
    private static final String SECKILL_DOMAIN_DEV = "//seckill.duibadev.com.cn";
    private static final String EMBED_DOMAIN_DEV = "//embedlog.duibadev.com.cn";
    private static final String ENV_DEV = "dev";
    private static final String ENV_TEST = "test";
    private static final String ENV_PRE = "prevpc";
    private static final String ENV_PROD = "prodvpc";
    private static final ImmutableMap<String, String> ACTIVITY_DOMAIN_MAP;
    private static final ImmutableMap<String, String> HOME_DOMAIN_MAP;
    private static final ImmutableMap<String, String> TRADE_DOMAIN_MAP;
    private static final ImmutableMap<String, String> GOODS_DOMAIN_MAP;
    private static final ImmutableMap<String, String> SECKILL_DOMAIN_MAP;
    private static final ImmutableMap<String, String> EMBEDLOG_DOMAIN_MAP;
    private final DomainService domainService;
    private final String env;

    public ResponseBodyDomainHander(DomainService domainService, String env) {
        this.domainService = domainService;
        this.env = env;
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body == null) {
            return null;
        }
        String strBody = null;
        boolean isString = false;
        if (body instanceof String) {
            strBody = (String)body;
            isString = true;
        } else {
            try {
                strBody = JSONObject.toJSONString((Object)body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            }
            catch (Exception e) {
                LOG.warn("convert to json failed, type={}, url={}", body.getClass(), (Object)String.valueOf(request.getURI()));
                return body;
            }
        }
        Pair<Boolean, String> pair = this.processDeadDomain(strBody, RequestLocal.getAppId());
        if (!((Boolean)pair.getValue0()).booleanValue()) {
            return body;
        }
        if (isString) {
            return pair.getValue1();
        }
        try {
            return JSONObject.parseObject((String)((String)pair.getValue1()));
        }
        catch (Exception e) {
            LOG.warn("failed to parse json, text={}", pair.getValue1());
            return body;
        }
    }

    private Pair<Boolean, String> processDeadDomain(String strBody, Long appId) {
        String embedlogDomainStatic;
        String seckillDomainStatic;
        String goodsDomainStatic;
        String tradeDomainStatic;
        String actDomainStatic;
        boolean replaced = false;
        String body = strBody;
        DomainConfigDto domainConfigDto = this.domainService.getSystemDomain(appId);
        String homeDomainStatic = (String)HOME_DOMAIN_MAP.get((Object)this.env);
        if (homeDomainStatic == null) {
            homeDomainStatic = HOME_DOMAIN_PROD;
        }
        if (body.contains(homeDomainStatic)) {
            body = body.replaceAll(homeDomainStatic, domainConfigDto.getHomeDomain());
            replaced = true;
        }
        if ((actDomainStatic = (String)ACTIVITY_DOMAIN_MAP.get((Object)this.env)) == null) {
            actDomainStatic = ACTIVITY_DOMAIN_PROD;
        }
        if (body.contains(actDomainStatic) && !actDomainStatic.equals(domainConfigDto.getActivityDomain())) {
            body = body.replaceAll(actDomainStatic, domainConfigDto.getActivityDomain());
            replaced = true;
        }
        if ((tradeDomainStatic = (String)TRADE_DOMAIN_MAP.get((Object)this.env)) == null) {
            tradeDomainStatic = TRADE_DOMAIN_PROD;
        }
        if (body.contains(tradeDomainStatic)) {
            body = body.replaceAll(tradeDomainStatic, domainConfigDto.getTradeDomain());
            replaced = true;
        }
        if ((goodsDomainStatic = (String)GOODS_DOMAIN_MAP.get((Object)this.env)) == null) {
            goodsDomainStatic = GOODS_DOMAIN_PROD;
        }
        if (body.contains(goodsDomainStatic)) {
            body = body.replaceAll(goodsDomainStatic, domainConfigDto.getGoodsDomain());
            replaced = true;
        }
        if ((seckillDomainStatic = (String)SECKILL_DOMAIN_MAP.get((Object)this.env)) == null) {
            seckillDomainStatic = SECKILL_DOMAIN_PROD;
        }
        if (body.contains(seckillDomainStatic)) {
            body = body.replaceAll(seckillDomainStatic, domainConfigDto.getSeckillDomain());
            replaced = true;
        }
        if ((embedlogDomainStatic = (String)EMBEDLOG_DOMAIN_MAP.get((Object)this.env)) == null) {
            embedlogDomainStatic = EMBED_DOMAIN_PROD;
        }
        if (body.contains(embedlogDomainStatic)) {
            body = body.replaceAll(embedlogDomainStatic, domainConfigDto.getEmbedDomain());
            replaced = true;
        }
        if (body.contains(CDN_DOMAIN_PROD)) {
            body = body.replaceAll(CDN_DOMAIN_PROD, domainConfigDto.getCdnDomain());
            replaced = true;
        }
        return Pair.with((Object)replaced, (Object)body);
    }

    static {
        HashMap<String, String> actDomainMap = new HashMap<String, String>();
        actDomainMap.put(ENV_DEV, ACTIVITY_DOMAIN_DEV);
        actDomainMap.put(ENV_TEST, ACTIVITY_DOMAIN_TEST);
        actDomainMap.put(ENV_PRE, ACTIVITY_DOMAIN_PROD);
        actDomainMap.put(ENV_PROD, ACTIVITY_DOMAIN_PROD);
        ACTIVITY_DOMAIN_MAP = ImmutableMap.copyOf(actDomainMap);
        HashMap<String, String> homeDomainMap = new HashMap<String, String>();
        homeDomainMap.put(ENV_DEV, HOME_DOMAIN_DEV);
        homeDomainMap.put(ENV_TEST, HOME_DOMAIN_TEST);
        homeDomainMap.put(ENV_PRE, HOME_DOMAIN_PROD);
        homeDomainMap.put(ENV_PROD, HOME_DOMAIN_PROD);
        HOME_DOMAIN_MAP = ImmutableMap.copyOf(homeDomainMap);
        HashMap<String, String> tradeDomainMap = new HashMap<String, String>();
        tradeDomainMap.put(ENV_DEV, TRADE_DOMAIN_DEV);
        tradeDomainMap.put(ENV_TEST, TRADE_DOMAIN_TEST);
        tradeDomainMap.put(ENV_PRE, TRADE_DOMAIN_PROD);
        tradeDomainMap.put(ENV_PROD, TRADE_DOMAIN_PROD);
        TRADE_DOMAIN_MAP = ImmutableMap.copyOf(tradeDomainMap);
        HashMap<String, String> goodsDomainMap = new HashMap<String, String>();
        goodsDomainMap.put(ENV_DEV, GOODS_DOMAIN_DEV);
        goodsDomainMap.put(ENV_TEST, GOODS_DOMAIN_TEST);
        goodsDomainMap.put(ENV_PRE, GOODS_DOMAIN_PROD);
        goodsDomainMap.put(ENV_PROD, GOODS_DOMAIN_PROD);
        GOODS_DOMAIN_MAP = ImmutableMap.copyOf(goodsDomainMap);
        HashMap<String, String> seckillDomainMap = new HashMap<String, String>();
        seckillDomainMap.put(ENV_DEV, SECKILL_DOMAIN_DEV);
        seckillDomainMap.put(ENV_TEST, SECKILL_DOMAIN_TEST);
        seckillDomainMap.put(ENV_PRE, SECKILL_DOMAIN_PROD);
        seckillDomainMap.put(ENV_PROD, SECKILL_DOMAIN_PROD);
        SECKILL_DOMAIN_MAP = ImmutableMap.copyOf(seckillDomainMap);
        HashMap<String, String> embedlogDomainMap = new HashMap<String, String>();
        embedlogDomainMap.put(ENV_DEV, EMBED_DOMAIN_DEV);
        embedlogDomainMap.put(ENV_TEST, EMBED_DOMAIN_TEST);
        embedlogDomainMap.put(ENV_PRE, EMBED_DOMAIN_PROD);
        embedlogDomainMap.put(ENV_PROD, EMBED_DOMAIN_PROD);
        EMBEDLOG_DOMAIN_MAP = ImmutableMap.copyOf(embedlogDomainMap);
    }
}

