package cn.com.duibabiz.component.actionevent;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Set;

@ConfigurationProperties(prefix = "user.action")
public class ActionEventConfig {
    //用户行为事件通知appid，对接欣兆阳数据回流小程序
    private Set<Long> eventNotifyAppIds = Sets.newHashSet(-1L);

    private String eventNotifyTopic;

    private Boolean logEvent = true;

    public String getEventNotifyTopic() {
        if (StringUtils.isNotBlank(eventNotifyTopic)) {
            return eventNotifyTopic;
        }
        if (SpringEnvironmentUtils.isDevEnv()) {
            return "userActEventNotifyDev";
        }
        if (SpringEnvironmentUtils.isTestEnv()) {
            return "userActEventNotifyTest";
        }
        if (SpringEnvironmentUtils.isPreEnv()) {
            return "userActEventNotifyPre";
        }
        if (SpringEnvironmentUtils.isProdEnv()) {
            return "userActEventNotifyProd";
        }
        throw new IllegalStateException("请检查用户行为事件通知topic: eventNotifyTopic");
    }

    public void setEventNotifyTopic(String eventNotifyTopic) {
        this.eventNotifyTopic = eventNotifyTopic;
    }

    public Set<Long> getEventNotifyAppIds() {
        return eventNotifyAppIds;
    }

    public void setEventNotifyAppIds(Set<Long> eventNotifyAppIds) {
        this.eventNotifyAppIds = eventNotifyAppIds;
    }

    public Boolean getLogEvent() {
        return logEvent;
    }

    public void setLogEvent(Boolean logEvent) {
        this.logEvent = logEvent;
    }

    public boolean isEventNotifyApp(Long appId){
        if(appId == null){
            return Boolean.FALSE;
        }

        return eventNotifyAppIds.contains(appId);
    }
}
