package cn.com.duibabiz.component.actionevent.impl;

import cn.com.duiba.consumer.center.api.dto.ConsumerDto;
import cn.com.duiba.consumer.center.api.remoteservice.RemoteConsumerService;
import cn.com.duibabiz.component.actionevent.ActionEventConfig;
import cn.com.duibabiz.component.actionevent.UserActionEventMQProducer;
import cn.com.duibabiz.component.actionevent.UserActionEventNotifyDto;
import cn.com.duibabiz.component.actionevent.UserActionEventService;
import cn.com.duibabiz.component.actionevent.UserEventTypeEnum;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class UserActionEventServiceImpl implements UserActionEventService, ApplicationContextAware, InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserActionEventServiceImpl.class);

    @Autowired
    private ActionEventConfig actionEventConfig;

    @Autowired
    private UserActionEventMQProducer userActionEventMQProducer;

    private ApplicationContext applicationContext;
    private static RemoteConsumerService remoteConsumerService;

    /**
     * 发送助力事件通知
     * @param consumerDto
     * @param eventType
     * @param actId
     * @param actType
     * @param inviter
     */
    @Override
    public Boolean sendMsg(ConsumerDto consumerDto, Integer eventType, String actId, String actType, Long inviter) {
        //非事件通知类App不发送消息
        if(consumerDto == null || !actionEventConfig.isEventNotifyApp(consumerDto.getAppId())){
            return Boolean.FALSE;
        }

        ConsumerDto inviterConsumer = null;
        if(inviter != null){
            try{
                inviterConsumer = remoteConsumerService.find(inviter);
            }catch (Exception e){
                LOGGER.warn("发送用户行为事件失败，查询consumerDto出错, {}:{}", inviter, consumerDto.getAppId(), e);
            }
        }
        Map<String, Object> bizParams = new HashMap<>();
        if(inviterConsumer != null){
            bizParams.put(UserActionEventNotifyDto.INVITER, inviterConsumer.getPartnerUserId());
        }

        return sendPrizeMsg(consumerDto, eventType, actId, actType, null, bizParams);
    }

    @Override
    public Boolean sendMsg(ConsumerDto consumerDto, Integer eventType, String actId, String actType){
        return sendPrizeMsg(consumerDto, eventType, actId, actType, null, null);
    }

    @Override
    public Boolean sendPrizeMsg(Long consumerId, Long appId, Integer eventType, String actId, String actType, String prizeName, Map<String, Object> bizParams){
        if(appId == null){
            return Boolean.FALSE;
        }
        //非事件通知类App不发送消息
        if(!actionEventConfig.isEventNotifyApp(appId)){
            return Boolean.FALSE;
        }

        if(consumerId == null){
            LOGGER.info("发送用户行为事件失败，consumerId或appId为空, {}:{}", consumerId, appId);
            return Boolean.FALSE;
        }

        ConsumerDto consumerDto = null;
        try{
            consumerDto = remoteConsumerService.find(consumerId);
        }catch (Exception e){
            LOGGER.warn("发送用户行为事件失败，查询consumerDto出错, {}:{}", consumerId, appId, e);
        }
        return sendPrizeMsg(consumerDto, eventType, actId, actType, prizeName, bizParams);
    }

    @Override
    public Boolean sendPrizeMsg(ConsumerDto consumerDto, Integer eventType, String actId, String actType, String prizeName, Map<String, Object> bizParams){
        //非强登后产生的事件行为不通知
        if(consumerDto == null || consumerDto.getId() == null){
            return Boolean.FALSE;
        }

        //非事件通知类App不发送消息
        if(!actionEventConfig.isEventNotifyApp(consumerDto.getAppId())){
            return Boolean.FALSE;
        }
        UserActionEventNotifyDto userActionEventNotifyDto = wrapUserActionEventNotifyDto(consumerDto, eventType, actId, actType, prizeName, bizParams);
        if(Objects.equals(eventType, UserEventTypeEnum.WINPRIZE.getCode())){
            LOGGER.info("send award event: {}", JSONObject.toJSONString(userActionEventNotifyDto));
        }else if(BooleanUtils.isTrue(actionEventConfig.getLogEvent())){
            LOGGER.info("send action event: {}", JSONObject.toJSONString(userActionEventNotifyDto));
        }

        userActionEventMQProducer.sendMsg(userActionEventNotifyDto, actionEventConfig.getEventNotifyTopic());
        return Boolean.TRUE;
    }

    private UserActionEventNotifyDto wrapUserActionEventNotifyDto(ConsumerDto consumerDto, Integer eventType, String actId, String actType, String prizeName, Map<String, Object> bizParams){
        return wrapUserActionEventNotifyDto(consumerDto.getAppId(), consumerDto.getId(), consumerDto.getPartnerUserId(), eventType, actId, actType, prizeName, bizParams);
    }

    private UserActionEventNotifyDto wrapUserActionEventNotifyDto(Long appId, Long consumerId, String uid, Integer eventType, String actId,  String actType, String prizeName, Map<String, Object> bizParams){
        UserActionEventNotifyDto dto = new UserActionEventNotifyDto();
        dto.setActId(actId);
        dto.setActType(actType);
        dto.setAppId(appId);

        Date now = new Date();
        dto.setBizId(generateBizId(appId, consumerId, actId, eventType, now.getTime()));
        dto.setConsumerId(consumerId);
        if(MapUtils.isNotEmpty(bizParams)){
            dto.setBizParams(JSONObject.toJSONString(bizParams));
        }

        dto.setEventDate(now);
        dto.setEventType(eventType);
        dto.setPartnerUserId(uid);
        dto.setPrizeName(prizeName);

        return dto;
    }

    /**
     * appid + cid + 活动id + 行为类型id + 时间
     */
    private String generateBizId(Long appId, Long consumerId, String actId, Integer eventType, long currentTime){
        StringBuilder builder = new StringBuilder();
        builder.append(appId).append("_").append(consumerId).append("_").append(actId).append("_").append(eventType).append(currentTime);
        return builder.toString();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        RemoteConsumerService remoteConsumerService = applicationContext.getBean(RemoteConsumerService.class);
        if(remoteConsumerService == null){
            throw new IllegalStateException("there must exists a bean of class RemoteConsumerService(in consumer-center)");
        }
        UserActionEventServiceImpl.remoteConsumerService = remoteConsumerService;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
