/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.actionevent;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="user.action")
public class ActionEventConfig {
    private Set<Long> eventNotifyAppIds = Sets.newHashSet((Object[])new Long[]{-1L});
    private String eventNotifyTopic;
    private Boolean logEvent = true;

    public String getEventNotifyTopic() {
        if (StringUtils.isNotBlank((CharSequence)this.eventNotifyTopic)) {
            return this.eventNotifyTopic;
        }
        if (SpringEnvironmentUtils.isDevEnv()) {
            return "userActEventNotifyDev";
        }
        if (SpringEnvironmentUtils.isTestEnv()) {
            return "userActEventNotifyTest";
        }
        if (SpringEnvironmentUtils.isPreEnv()) {
            return "userActEventNotifyPre";
        }
        if (SpringEnvironmentUtils.isProdEnv()) {
            return "userActEventNotifyProd";
        }
        throw new IllegalStateException("\u8bf7\u68c0\u67e5\u7528\u6237\u884c\u4e3a\u4e8b\u4ef6\u901a\u77e5topic: eventNotifyTopic");
    }

    public void setEventNotifyTopic(String eventNotifyTopic) {
        this.eventNotifyTopic = eventNotifyTopic;
    }

    public Set<Long> getEventNotifyAppIds() {
        return this.eventNotifyAppIds;
    }

    public void setEventNotifyAppIds(Set<Long> eventNotifyAppIds) {
        this.eventNotifyAppIds = eventNotifyAppIds;
    }

    public Boolean getLogEvent() {
        return this.logEvent;
    }

    public void setLogEvent(Boolean logEvent) {
        this.logEvent = logEvent;
    }

    public boolean isEventNotifyApp(Long appId) {
        if (appId == null) {
            return Boolean.FALSE;
        }
        return this.eventNotifyAppIds.contains(appId);
    }
}

