package cn.com.duiba.biz.tool.duiba.cros;

import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by wenqi.huang on 2016/10/18.
 */
public class UrlUtils {

    /**
     * 如果url不包含http或https协议，添加之
     * @param url
     * @param request
     * @return
     */
    public static String addScheme(String url, HttpServletRequest request){
        url = StringUtils.trimToEmpty(url);
        if(request!=null) {
            String requestScheme = request.getScheme();
            if (url.startsWith("//")) {
                url = requestScheme + ":" + url;
            }
        }
        return url;
    }

    /**
     *
     * @param url
     * @param scheme
     * @return
     */
    public static String addScheme(String url, String scheme){
        url = StringUtils.trimToEmpty(url);

        if (url.startsWith("//")) {
            url = scheme + ":" + url;
        }

        return url;
    }

    /**
     * 解析出url请求的路径，包括页面
     * @Desc 从wolf包中迁移出来,不能忽略url地址中的参数大小写
     * @param  url
     * @return url路径
     */
    public static String urlPage(String url) {
        String strPage = null;
        String[] arrSplit;
        arrSplit = url.split("[?]");
        if (url.length() > 0) {
            if (arrSplit.length > 1) {
                if (arrSplit[0] != null) {
                    strPage = arrSplit[0];
                }
            } else {
                strPage = url;
            }
        }
        return strPage;
    }
}
