package cn.com.duibabiz.component.actionevent;

import com.alibaba.fastjson.JSONObject;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.nio.charset.Charset;

public class UserActionEventMQProducer implements ApplicationContextAware, InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserActionEventMQProducer.class);

    //用户事件行为通知tag
    public static final String DUIBA_USEREVENT_NOTIFY_TAG = "duiba-userevent-notify";

    private ApplicationContext applicationContext;
    private static DefaultMQProducer rocketMqProducer;

    public void sendMsg(UserActionEventNotifyDto userActionEventNotifyDto, String userEventNotifyTopic){
        sendMsg(userActionEventNotifyDto, userEventNotifyTopic, DUIBA_USEREVENT_NOTIFY_TAG);
    }

    private void sendMsg(UserActionEventNotifyDto userActionEventNotifyDto, String userEventNotifyTopic, String tag) {
        String info = null;
        try {
            info = JSONObject.toJSONString(userActionEventNotifyDto);
            byte[] body = info.getBytes(Charset.forName("utf-8"));
            Message message = new Message(userEventNotifyTopic, tag, body);
            SendResult sendResult = rocketMqProducer.send(message);
            if (sendResult.getSendStatus() != SendStatus.SEND_OK) {
                LOGGER.error("发送用户行为事件失败,msg={}", info);
            }
        } catch (Exception e) {
            LOGGER.error("发送用户行为事件异常, msg={}", info, e);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        DefaultMQProducer rocketMqProducer = applicationContext.getBean(DefaultMQProducer.class);
        if(rocketMqProducer == null){
            throw new IllegalStateException("there must exists a bean of class DefaultMQProducer(in spring-boot-starter-rocketmq)");
        }
        UserActionEventMQProducer.rocketMqProducer = rocketMqProducer;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
