package cn.com.duibabiz.component.actionevent;

public enum UserEventTypeEnum {
    VISIT(1, "访问"),
    JOIN(2, "参与"),
    SHARE(3, "分享"),
    ASSIST(4, "助力"),
    WINPRIZE(5, "中奖"),
    ;

    private int code;
    private String desc;

    UserEventTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static UserEventTypeEnum ofCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (UserEventTypeEnum type : values()) {
            if (code == type.getCode()) {
                return type;
            }
        }
        return null;
    }
}
