package cn.com.duibabiz.component.oss;

import cn.com.duiba.boot.exception.BizException;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public interface OssClient {

    /**
     * 普通上传
     * @param bucketName 非必填 不填默认使用统一配置
     * @param path 路径 非必填 路径不能以/ 开头 例如 a/b/c.png
     * @param file 文件 必填
     * @return 成功则返回 url 失败则抛出异常
     * @throws BizException
     */
    String upload(String bucketName, String path, File file) throws BizException;

    /**
     * 普通上传
     * @param bucketName 非必填 不填默认使用统一配置
     * @param path 路径 非必填 路径不能以/ 开头 例如 a/b/c.png
     * @param base64 文件的base64 必填
     * @return 成功则返回 url 失败则抛出异常
     * @throws BizException
     */
    String upload(String bucketName, String path, String base64) throws BizException;

    /**
     * 普通上传
     * @param bucketName 非必填 不填默认使用统一配置
     * @param path 路径 非必填 路径不能以/ 开头  例如 a/b/c.png
     * @param inputStream 文件流 必填
     * @param fileName 文件名带后缀 必填
     * @return 成功则返回 url 失败则抛出异常
     * @throws BizException
     */
    String upload(String bucketName, String path, InputStream inputStream,String fileName) throws BizException;

    /**
     * 追加上传
     * @param bucketName 非必填 不填默认使用统一配置
     * @param path 路径 非必填 路径不能以/ 开头  例如 a/b/c.png 当追加的不是一个新文件的时候必传
     * @param inputStream 文件流 必填
     * @param fileName 文件名带后缀 必填
     * @param position 追加的位置 必填
     * @return 成功则返回 位置/文件名 失败则抛出异常
     * @throws BizException
     */
    OssAppendEntity appendUpload(String bucketName, String path, InputStream inputStream,String fileName,Long position) throws BizException;


    /**
     * 普通下载
     * @param bucketName 非必填 不填默认使用统一配置
     * @param path 路径 必填 路径不能以/ 开头
     * @return 成功则返回 流 失败则抛出异常
     * @throws BizException
     */
    OssDownloadEntity download(String bucketName, String path) throws BizException;


    /**
     * 判断文件是否存在
     * @param bucketName 非必填 不填默认使用统一配置
     * @param path 路径 必填 路径不能以/ 开头
     * @return 成功则返回 流 失败则抛出异常
     * @throws BizException
     */
    Boolean fileExist(String bucketName, String path) throws BizException;


    /**
     * 场景检测
     * @param url
     * @param scenes
     * * porn:识别图片中的色情内容
     * * terrorism:识别图片中的暴恐涉政内容
     * * ad:识别图片中的广告以及文字违规信息
     * * live:识别图片中出现的黑屏、黑边、昏暗画面、画中画、抽烟、打架等不良场景
     * * qrcode:识别图片中的二维码
     * * logo:识别图片中的logo信息，例如台标，商标等
     * @return 为null 说明检测通过 否则给出错误信息
     */
    String sceneDetection(String url, List<String> scenes) throws Exception;


}
