/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.email;

import cn.com.duibabiz.component.email.DuibaEmailHelper;
import cn.com.duibabiz.component.email.DuibaEmailProperties;
import java.util.Properties;
import javax.mail.internet.MimeMessage;
import javax.net.ssl.SSLSocketFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
@ConditionalOnClass(value={JavaMailSender.class, MimeMessage.class})
@EnableConfigurationProperties(value={DuibaEmailProperties.class})
public class DuibaEmailAutoConfiguration {
    @Autowired
    private DuibaEmailProperties duibaEmailProperties;

    @Bean(name={"javaMailSender"})
    public JavaMailSender javaMailSender() {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(this.duibaEmailProperties.getHost());
        sender.setPort(this.duibaEmailProperties.getPort().intValue());
        sender.setProtocol(this.duibaEmailProperties.getProtocol());
        sender.setDefaultEncoding(this.duibaEmailProperties.getDefaultEncoding());
        sender.setUsername(this.duibaEmailProperties.getUsername());
        sender.setPassword(this.duibaEmailProperties.getPassword());
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.ssl.enable", (Object)true);
        props.put("mail.smtp.socketFactory.port", (Object)465);
        props.put("mail.smtp.timeout", (Object)3000);
        props.put("mail.smtp.socketFactory.class", SSLSocketFactory.class);
        props.put("mail.smtp.socketFactory.fallback", (Object)false);
        props.put("mail.smtp.quitwait", (Object)false);
        sender.setJavaMailProperties(props);
        return sender;
    }

    @Bean
    public DuibaEmailHelper duibaEmailHelper(@Qualifier(value="javaMailSender") JavaMailSender sender) {
        return new DuibaEmailHelper();
    }
}

