/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.redis.impl;

import cn.com.duibabiz.component.redis.RedisClient;
import cn.com.duibabiz.component.redis.RedisClientProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.util.Assert;

public class RedisClientImpl<K, V>
implements RedisClient<K, V> {
    @Resource
    private RedisTemplate<K, V> redisTemplate;
    @Autowired
    private RedisClientProperties properties;

    @Override
    public V get(Object key) {
        return (V)this.opsForValue().get(key);
    }

    @Override
    public List<V> multiGet(Collection<K> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>(keys.size());
        for (int i = 0; i < keys.size(); i += this.properties.getSplit().intValue()) {
            byte[][] rawKeys = new byte[this.properties.getSplit().intValue()][];
            int counter = 0;
            for (K hashKey : keys) {
                rawKeys[counter++] = this.rawKey(hashKey);
                if (counter != this.properties.getSplit()) continue;
                break;
            }
            List rawValues = (List)this.execute(connection -> connection.mGet(rawKeys), true);
            result.addAll(rawValues);
        }
        return this.deserializeValues(result);
    }

    @Override
    public Long increment(K key, long delta) {
        return this.opsForValue().increment(key, delta);
    }

    @Override
    public Double increment(K key, double delta) {
        return this.opsForValue().increment(key, delta);
    }

    @Override
    public Boolean expire(K key, long timeout, TimeUnit unit) {
        return this.redisTemplate.expire(key, timeout, unit);
    }

    @Override
    public void set(K key, V value, long timeout, TimeUnit unit) {
        this.opsForValue().set(key, value, timeout, unit);
    }

    @Override
    public Boolean setIfAbsent(K key, V value) {
        return this.opsForValue().setIfAbsent(key, value);
    }

    private byte[] rawKey(Object key) {
        Assert.notNull((Object)key, (String)"non null key required");
        if (this.keySerializer() == null && key instanceof byte[]) {
            return (byte[])key;
        }
        return this.keySerializer().serialize(key);
    }

    private List<V> deserializeValues(List<byte[]> rawValues) {
        if (this.valueSerializer() == null) {
            return rawValues;
        }
        return SerializationUtils.deserialize(rawValues, (RedisSerializer)this.valueSerializer());
    }

    private RedisSerializer keySerializer() {
        return this.redisTemplate.getKeySerializer();
    }

    private RedisSerializer valueSerializer() {
        return this.redisTemplate.getValueSerializer();
    }

    private <T> T execute(RedisCallback<T> callback, boolean b) {
        return (T)this.redisTemplate.execute(callback, b);
    }

    private ValueOperations<K, V> opsForValue() {
        return this.redisTemplate.opsForValue();
    }
}

