/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.versioncheck;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duibabiz.component.versioncheck.BizToolVersion;
import cn.com.duibabiz.component.versioncheck.BizVersionCheckProperties;
import cn.com.duibabiz.tools.BizToolJarVersionUtils;
import cn.com.duibaboot.ext.autoconfigure.DuibaBootVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
@ConditionalOnClass(value={MainContextRefreshedEvent.class, SpringEnvironmentUtils.class})
@EnableConfigurationProperties(value={BizVersionCheckProperties.class})
public class JarVersionCheckConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(JarVersionCheckConfiguration.class);
    private static final String EXIT_MSG = "\u542f\u52a8\u5931\u8d25,\u5e94\u7528\u5173\u95ed......";
    @Autowired
    private BizVersionCheckProperties bizVersionCheckProperties;

    @EventListener(value={MainContextRefreshedEvent.class})
    public void checkVersion() {
        String duibaExtVersion;
        if (SpringEnvironmentUtils.isProdEnv()) {
            return;
        }
        String bizToolVersion = BizToolVersion.getVersion();
        if (bizToolVersion == null) {
            throw new IllegalArgumentException("\u672a\u68c0\u6d4b\u5230biz-tool\u7248\u672c\u53f7,\u8bf7\u8054\u7cfb@\u5b59\u957f\u7eaa \u8fdb\u884c\u6392\u67e5");
        }
        String bizToolBaseVersion = this.bizVersionCheckProperties.getBiztool();
        Boolean adopt = BizToolJarVersionUtils.isJarVersionEqualOrGreaterThan(bizToolVersion, bizToolBaseVersion);
        if (adopt == null) {
            LOG.error("\u68c0\u6d4b\u5230\u9879\u76ee\u5f53\u524d\u5f15\u5165biz-tool\u7248\u672c:{},\u7248\u672c\u5b9a\u4e49\u4e0d\u7b26\u5408\u8981\u6c42,\u8bf7\u5347\u81f3:{}\u6216\u4ee5\u4e0a", (Object)bizToolVersion, (Object)bizToolBaseVersion);
            LOG.error(EXIT_MSG);
            System.exit(1);
        }
        if (!adopt.booleanValue()) {
            LOG.error("\u68c0\u6d4b\u5230\u9879\u76ee\u5f53\u524d\u5f15\u5165biz-tool\u7248\u672c:{}\u8fc7\u4f4e,\u8bf7\u5347\u81f3:{}\u6216\u4ee5\u4e0a", (Object)bizToolVersion, (Object)bizToolBaseVersion);
            LOG.error(EXIT_MSG);
            System.exit(1);
        }
        if ((duibaExtVersion = DuibaBootVersion.getVersion()) == null) {
            LOG.warn("\u672a\u68c0\u6d4b\u5230duiba-boot-ext\u7248\u672c\u53f7,\u8bf7\u8054\u7cfb@\u5b59\u957f\u7eaa \u6392\u67e5");
            return;
        }
        String duibaBootBaseVersion = this.bizVersionCheckProperties.getDuibaext();
        adopt = BizToolJarVersionUtils.isJarVersionEqualOrGreaterThan(duibaExtVersion, duibaBootBaseVersion);
        if (adopt == null) {
            throw new IllegalArgumentException("\u68c0\u6d4b\u5230\u9879\u76ee\u5f53\u524d\u5f15\u5165duiba-boot-ext\u7248\u672c:" + duibaExtVersion + ",\u7248\u672c\u5b9a\u4e49\u4e0d\u7b26\u5408\u8981\u6c42,\u8bf7\u786e\u4fdd\u7248\u672c\u4e0d\u4f4e\u4e8e:" + duibaBootBaseVersion);
        }
        if (!adopt.booleanValue()) {
            LOG.error("\u68c0\u6d4b\u5230\u9879\u76ee\u5f53\u524d\u5f15\u5165duiba-boot-ext\u7248\u672c:{}\u8fc7\u4f4e,\u8bf7\u5347\u81f3:{}\u6216\u4ee5\u4e0a", (Object)duibaExtVersion, (Object)duibaBootBaseVersion);
            LOG.error(EXIT_MSG);
            System.exit(1);
        }
    }
}

