package cn.com.duiba.biz.tool.duiba.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.security.MessageDigest;
import java.util.*;

/**
 * @ClassName SHA256Util
 * @Description
 * @Author liheping
 * @Date 2021/7/26
 **/
public class SHA256Util {

    private static final Logger log = LoggerFactory.getLogger(SHA256Util.class);


    /**
     * @description SHA256 加密验签
     * @author liheping
     * @date 2021/7/23
     */
    public static boolean sha256SignVerify(String appSecret, HttpServletRequest request) {
        Map<String, String[]> map = request.getParameterMap();
        Map<String, String> params = new HashMap<>();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            params.put(key, ((String[]) map.get(key))[0]);
        }
        return sha256SignVerify(appSecret, params);
    }


    /**
     * @description SHA256 加密验签
     * @author liheping
     * @date 2021/7/23
     */
    public static boolean sha256SignVerify(String appSecret, Map<String, String> params) {
        Map<String, String> map = new HashMap();
        Iterator<String> iterator = params.keySet().iterator();

        String key;
        while (iterator.hasNext()) {
            key = iterator.next();
            if (!key.equals("sign") && !key.toLowerCase().equals("appsecret")) {
                map.put(key, (String) params.get(key));
            }
        }

        map.put("appSecret", appSecret);
        String sign = sha256Sign(map);
        log.info("sha256-sign1:{}, sign2:{}", sign, params.get("sign"));
        if (sign.equals(params.get("sign"))) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * @description sha256加密
     * @author liheping
     * @date 2021/7/23
     */
    public static String sha256Sign(Map<String, String> params) {
        List<String> keys = new ArrayList<>(params.keySet());
        Collections.sort(keys);
        StringBuilder stringBuilder = new StringBuilder();
        for (String s : keys) {
            stringBuilder.append(params.get(s));
        }

        String sign = "";
        try {
            String src = stringBuilder.toString();
            sign = sha256(src.getBytes());
        } catch (Exception e) {
            log.error("SHA-256 error", e);
            return "";
        }
        return sign;
    }

    private static String sha256(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return bytesToHex(md.digest(data));
        } catch (Exception ex) {
            log.warn("Never happen.", ex);
            return null;
        }
    }

    private static String bytesToHex(byte[] bytes) {
        String hexArray = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            int bi = b & 0xff;
            sb.append(hexArray.charAt(bi >> 4));
            sb.append(hexArray.charAt(bi & 0xf));
        }
        return sb.toString();
    }
}
