package cn.com.duibabiz.component.oss;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author XuJing
 * @since 2020/5/14 10:09 上午
 */
@ConfigurationProperties(prefix = "oss")
public class OssProperties {
    /**
     * 请求地址前缀
     */
    private String endPoint;

    /**
     * 命名空间
     */
    private String bucketName;

    /**
     * 接口路径
     */
    private static final String uploadPath = "oss/upload";
    private static final String appendUploadPath = "oss/uploadAppend";
    private static final String downloadPath = "oss/download";
    private static final String existPath = "oss/exist";
    private static final String sceneDetectionPath = "inspect/image";

    public static final String devBuckName = "daily-duiba";
    public static final String testBuckName = "daily-duiba";
    public static final String preBuckName = "duiba";
    public static final String prodBuckName = "duiba";


    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() throws BizException {
        if (StringUtils.isNotBlank(bucketName)) {
            return bucketName;
        }
        if (SpringEnvironmentUtils.isDevEnv()) {
            return OssProperties.devBuckName;
        }
        if (SpringEnvironmentUtils.isTestEnv()) {
            return OssProperties.testBuckName;
        }
        if (SpringEnvironmentUtils.isPreEnv()) {
            return OssProperties.preBuckName;
        }
        if (SpringEnvironmentUtils.isProdEnv()) {
            return OssProperties.prodBuckName;
        }
        throw new BizException("请检查bucketName");
    }

    public String getUploadUrl() {
        return this.getEndPoint() + OssProperties.uploadPath;
    }

    public String getDownloadUrl() {
        return this.getEndPoint() + OssProperties.downloadPath;
    }

    public String getAppendUploadUrl() {
        return this.getEndPoint() + OssProperties.appendUploadPath;
    }

    public String getExistUrl() {
        return this.getEndPoint() + OssProperties.existPath;
    }

    public String getSceneDetectionUrl() {
        return this.getEndPoint() + OssProperties.sceneDetectionPath;
    }

    public String getEndPoint() {
        return endPoint;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

}
