package cn.com.duiba.biz.tool.duiba.util;

import com.google.common.collect.ImmutableSet;
import org.apache.commons.lang.StringUtils;

/**
 * @Author: lufeng
 * @Description: 直辖市工具类
 * @Date: Created in 2018/12/12
 */
public class ZXSProvinceUtil {
    //110000 北京市 120000 天津市 310000 上海市 50000 重庆市
    private static final ImmutableSet<String> ZXS_CODE = ImmutableSet.of("110000", "120000", "310000", "50000");

    //私有构造方法
    private ZXSProvinceUtil(){
    }
    
    //判断是否是直辖市
    public static Boolean isZXSProvince(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        if (code.length() < 2) {
            return null;
        }
        code = code.substring(0,2) + "0000";
        if (ZXS_CODE.contains(code)) {
            return true;
        }
        return false;
    }

}