package cn.com.duibabiz.component.filters;

import cn.com.duibaboot.ext.autoconfigure.accesslog.AccessLogFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.servlet.DispatcherType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/**
 * 自动配置filter
 * Created by sunchangji on 2019/4/16.
 */
@Configuration
@ConditionalOnClass({AccessLogFilter.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties(DuibaHostConfig.class)
public class DuibaAccessLogHostConfiguration {

	@Bean
	public DuibaHostFilter duibaHostFilter() {
		return new DuibaHostFilter();
	}

	@Bean
	public FilterRegistrationBean acesslogHostHttpFilterConfigurer(DuibaHostFilter duibaHostFilter) {
		FilterRegistrationBean registrationBean = new FilterRegistrationBean();
		registrationBean.setFilter(duibaHostFilter);
		List<String> urlPatterns = new ArrayList<>();
		urlPatterns.add("/*");
		registrationBean.setUrlPatterns(urlPatterns);
		registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
		registrationBean.setOrder(120);
		return registrationBean;
	}


}
