/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.tool.duiba.client;

import cn.com.duiba.biz.tool.duiba.client.DESCrypto;
import cn.com.duiba.biz.tool.duiba.client.DuibaConsumerCookieClient;
import cn.com.duiba.biz.tool.duiba.dto.ConsumerCookieDto;
import cn.com.duiba.consumer.center.api.dto.ConsumerDto;
import cn.com.duiba.consumer.center.api.remoteservice.RemoteConsumerService;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import cn.com.duiba.idmaker.service.api.remoteservice.kms.RemoteKmsService;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RequestLocal
implements ApplicationContextAware,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(RequestLocal.class);
    public static final String ADSLOTID = "adslotId";
    private ApplicationContext applicationContext;
    private static RemoteConsumerService remoteConsumerService;
    private static RemoteAppService remoteAppService;
    private static Object remoteAppDirectService;
    private static DuibaConsumerCookieClient duibaConsumerCookieClient;
    private static boolean needLogin;
    private static String oldConsumerEncryptKey;
    private static String cookieDomain;
    private static final LoadingCache<String, Optional<Long>> appKey2IdCache;
    private static final LoadingCache<Long, Boolean> appId2DirectCache;
    private static final LoadingCache<Long, Boolean> appId2ForbidStatusCache;
    private static final ThreadLocal<HttpRequestDto> local;
    private static final String forbiddenPageHtml;
    private static final String YJQ_PATTERN = "^26851.activity.*.m.duiba.com.cn";

    public void setNeedLogin(boolean needLogin) {
        RequestLocal.needLogin = needLogin;
    }

    private static HttpRequestDto get() {
        HttpRequestDto rl = local.get();
        if (rl == null) {
            rl = new HttpRequestDto();
            local.set(rl);
        }
        return rl;
    }

    public static Long getCid() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.consumerCookieDto == null ? null : requestLocal.consumerCookieDto.getCid();
    }

    public static Long getAppId() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.consumerCookieDto == null ? null : requestLocal.consumerCookieDto.getAppId();
    }

    public static String getPartnerUserId() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.consumerCookieDto == null ? null : requestLocal.consumerCookieDto.getPartnerUserId();
    }

    public static ConsumerDto getConsumerDO() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.getConsumerDO();
    }

    public static ConsumerDto getConsumerAddr3DESDto() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.getConsumerAddr3DESDto();
    }

    public static AppSimpleDto getConsumerAppDO() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.getConsumerAppDO();
    }

    public static String getTokenId() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.getTokenId();
    }

    public static String getDeap() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.getDeap();
    }

    public static String getIp() {
        return RequestTool.getIpAddr((HttpServletRequest)RequestLocal.getRequest());
    }

    public static String getUserAgent() {
        return RequestTool.getUserAgent((HttpServletRequest)RequestLocal.getRequest());
    }

    public static String getSlotId() {
        HttpServletRequest request = RequestLocal.getRequest();
        String slotId = request.getParameter(ADSLOTID);
        if (StringUtils.isBlank((String)slotId)) {
            slotId = RequestTool.getCookie((HttpServletRequest)request, (String)"_coll_slot");
        }
        return slotId;
    }

    public static HttpServletRequest getRequest() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.getRequest();
    }

    public static boolean isIos() {
        return RequestTool.isIos((HttpServletRequest)RequestLocal.getRequest());
    }

    public static HttpServletResponse getResponse() {
        HttpRequestDto requestLocal = RequestLocal.get();
        return requestLocal.getResponse();
    }

    public static boolean isLoginConsumer() {
        String partnerUserId = RequestLocal.getPartnerUserId();
        return partnerUserId != null && !"not_login".equals(partnerUserId);
    }

    public static boolean isShareConsumer() {
        return "share".equals(RequestLocal.getPartnerUserId());
    }

    public static void injectConsumerInfoIntoCookie(ConsumerDto consumer) {
        RequestLocal.injectConsumerInfoIntoCookie(consumer, false);
    }

    public static void injectConsumerInfoIntoCookie(ConsumerDto consumer, boolean isFromCommercial) {
        if (!needLogin) {
            throw new IllegalStateException("not allowed to login");
        }
        HttpRequestDto requestLocal = RequestLocal.get();
        ConsumerCookieDto consumerCookieDto = duibaConsumerCookieClient.injectConsumerInfoIntoCookie(consumer, requestLocal.getRequest(), requestLocal.getResponse(), cookieDomain, oldConsumerEncryptKey, isFromCommercial);
        requestLocal.consumerCookieDto = consumerCookieDto;
        requestLocal.consumerDO = null;
        requestLocal.consumerAppDO = null;
        requestLocal.tokenId = (String)requestLocal.getRequest().getAttribute("c_tokenId");
    }

    public static void injectConsumerInfoIntoCookieForYjq(ConsumerDto consumer) {
        logger.info("yjq \u6ce8\u5165cookie consumer={}", (Object)JSON.toJSONString((Object)consumer));
        HttpRequestDto requestLocal = RequestLocal.get();
        ConsumerCookieDto consumerCookieDto = duibaConsumerCookieClient.injectConsumerInfoIntoCookieForYjq(consumer, requestLocal.getRequest(), requestLocal.getResponse(), cookieDomain, oldConsumerEncryptKey);
        requestLocal.consumerCookieDto = consumerCookieDto;
        requestLocal.consumerDO = null;
        requestLocal.consumerAppDO = null;
        requestLocal.tokenId = (String)requestLocal.getRequest().getAttribute("c_tokenId");
    }

    public static boolean setThreadLocallyAndLimitQps(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestLocal.clearThreadLocally();
        if (request == null || response == null) {
            throw new IllegalArgumentException("request or response must not be null");
        }
        if (org.apache.commons.lang3.StringUtils.endsWithAny((CharSequence)request.getRequestURI(), (CharSequence[])new CharSequence[]{".js", ".css", ".png", ".jpg", ".gif"})) {
            return false;
        }
        HttpRequestDto dto = RequestLocal.get();
        String serverName = request.getServerName();
        boolean matches = Pattern.matches(YJQ_PATTERN, serverName);
        if (matches) {
            return dto.initAndLimitQpsForYjq(request, response);
        }
        return dto.initAndLimitQps(request, response);
    }

    public static String getCookieDomain(HttpServletRequest request) {
        String domain = duibaConsumerCookieClient.getRequestDomain(request, cookieDomain);
        if (domain == null) {
            return cookieDomain;
        }
        return domain;
    }

    public static void clearThreadLocally() {
        local.remove();
    }

    private static void showForbiddenPage(HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        response.setCharacterEncoding("utf-8");
        try (PrintWriter out = response.getWriter();){
            out.write(forbiddenPageHtml);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        RemoteAppService remoteAppService = (RemoteAppService)this.applicationContext.getBean(RemoteAppService.class);
        if (remoteAppService == null) {
            throw new IllegalStateException("there must exists a bean of class RemoteAppService(in developer-center)");
        }
        RemoteConsumerService remoteConsumerService = (RemoteConsumerService)this.applicationContext.getBean(RemoteConsumerService.class);
        if (remoteConsumerService == null) {
            throw new IllegalStateException("there must exists a bean of class RemoteConsumerService(in consumer-center)");
        }
        RemoteKmsService remoteKmsService = (RemoteKmsService)this.applicationContext.getBean(RemoteKmsService.class);
        if (remoteKmsService == null) {
            throw new IllegalStateException("there must exists a bean of class RemoteKmsService(in idmaker-service)");
        }
        Class<?> clazz = Class.forName("cn.com.duiba.developer.center.api.remoteservice.devapp.RemoteAppDirectService");
        Object remoteAppDirectService = this.applicationContext.getBean(clazz);
        if (remoteAppDirectService == null) {
            throw new IllegalStateException("there must exists a bean of class RemoteAppDirectService(in activity-center)");
        }
        RequestLocal.remoteAppDirectService = remoteAppDirectService;
        if (needLogin) {
            cookieDomain = this.applicationContext.getEnvironment().getProperty("app.cross.domain");
            if (cookieDomain == null || cookieDomain.isEmpty()) {
                throw new IllegalStateException("property:[app.cross.domain] does not exist");
            }
            if (cookieDomain.startsWith(".") || cookieDomain.startsWith("-")) {
                cookieDomain = cookieDomain.substring(1);
            }
        }
        if ((oldConsumerEncryptKey = this.applicationContext.getEnvironment().getProperty("app.consumer.encrypt.key")) == null || oldConsumerEncryptKey.isEmpty()) {
            throw new IllegalStateException("property:[app.consumer.encrypt.key] does not exist");
        }
        RequestLocal.remoteAppService = remoteAppService;
        RequestLocal.remoteConsumerService = remoteConsumerService;
        duibaConsumerCookieClient = new DuibaConsumerCookieClient(remoteKmsService);
    }

    static {
        needLogin = true;
        local = new ThreadLocal();
        appKey2IdCache = CacheBuilder.newBuilder().concurrencyLevel(32).softValues().maximumSize(100000L).refreshAfterWrite(8L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Optional<Long>>(){

            public Optional<Long> load(String key) throws Exception {
                AppSimpleDto app = (AppSimpleDto)remoteAppService.getAppByAppKey(key).getResult();
                if (app != null) {
                    return Optional.of((Object)app.getId());
                }
                return Optional.absent();
            }
        });
        appId2DirectCache = CacheBuilder.newBuilder().concurrencyLevel(32).softValues().maximumSize(100000L).refreshAfterWrite(25L, TimeUnit.MINUTES).expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, Boolean>(){

            public Boolean load(Long key) throws Exception {
                Method m = remoteAppDirectService.getClass().getDeclaredMethod("findByAppId", Long.class);
                Long id = (Long)m.invoke(remoteAppDirectService, key);
                if (id != null) {
                    return true;
                }
                return false;
            }
        });
        appId2ForbidStatusCache = CacheBuilder.newBuilder().concurrencyLevel(32).softValues().maximumSize(100000L).refreshAfterWrite(2L, TimeUnit.MINUTES).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, Boolean>(){

            public Boolean load(Long key) throws Exception {
                AppSimpleDto app = (AppSimpleDto)remoteAppService.getSimpleApp(key).getResult();
                if (app != null) {
                    return app.isAppSwitch(27);
                }
                return false;
            }
        });
        try (InputStream in = RequestLocal.class.getResourceAsStream("/bt_common_html/no_permission.html");){
            forbiddenPageHtml = IOUtils.toString((InputStream)in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class AppMethodInterceptor
    implements MethodInterceptor {
        private boolean isLazyInitted = false;
        private HttpRequestDto httpRequestDto;

        public AppMethodInterceptor(HttpRequestDto httpRequestDto) {
            this.httpRequestDto = httpRequestDto;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (this.isLazyInitted) {
                return invocation.proceed();
            }
            Method m = invocation.getMethod();
            if (m.getName().equals("getId") || m.getName().equals("toString") || m.getName().equals("equals") || m.getName().equals("hashCode")) {
                return invocation.proceed();
            }
            AppSimpleDto originalApp = (AppSimpleDto)invocation.getThis();
            AppSimpleDto appInDb = (AppSimpleDto)remoteAppService.getSimpleApp(originalApp.getId()).getResult();
            BeanUtils.copyProperties((Object)appInDb, (Object)originalApp);
            this.isLazyInitted = true;
            this.httpRequestDto.consumerAppDO = originalApp;
            return invocation.proceed();
        }
    }

    private static class ConsumerMethodInterceptor
    implements MethodInterceptor {
        private boolean isLazyInitted = false;
        private HttpRequestDto httpRequestDto;

        public ConsumerMethodInterceptor(HttpRequestDto httpRequestDto) {
            this.httpRequestDto = httpRequestDto;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (this.isLazyInitted) {
                return invocation.proceed();
            }
            Method m = invocation.getMethod();
            if (m.getName().equals("getId") || m.getName().equals("getAppId") || m.getName().equals("getPartnerUserId") || m.getName().equals("toString") || m.getName().equals("equals") || m.getName().equals("hashCode")) {
                return invocation.proceed();
            }
            ConsumerDto originalConsumer = (ConsumerDto)invocation.getThis();
            ConsumerDto consumerInDb = remoteConsumerService.find(originalConsumer.getId());
            BeanUtils.copyProperties((Object)consumerInDb, (Object)originalConsumer);
            this.isLazyInitted = true;
            this.httpRequestDto.consumerDO = originalConsumer;
            return invocation.proceed();
        }
    }

    private static class HttpRequestDto {
        private ConsumerDto consumerDO;
        private AppSimpleDto consumerAppDO;
        private ConsumerCookieDto consumerCookieDto;
        private String tokenId;
        private String deap;
        private HttpServletRequest request;
        private HttpServletResponse response;

        private HttpRequestDto() {
        }

        public boolean initAndLimitQps(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this.request = request;
            this.response = response;
            ConsumerCookieDto consumerFromWdata4 = null;
            ConsumerCookieDto consumerFromWdata3 = null;
            try {
                consumerFromWdata4 = duibaConsumerCookieClient.getConsumerCookieDto(request);
            }
            catch (Exception e) {
                logger.info("get user from wdata4 error,will try to use wdata3.", (Throwable)e);
            }
            String appKey = request.getParameter("appKey");
            boolean openBs = "openbs".equals(request.getParameter("openBs"));
            if (consumerFromWdata4 == null) {
                boolean preferCookieForEver = false;
                consumerFromWdata3 = this.parseOldWdata3(preferCookieForEver);
            }
            this.tokenId = RequestTool.getCookie((HttpServletRequest)request, (String)"tokenId");
            if (this.tokenId == null || this.tokenId.isEmpty()) {
                this.tokenId = RequestTool.getCookie((HttpServletRequest)request, (String)"wdata3");
            }
            boolean preferUseWdata4 = false;
            if (null != appKey && needLogin && openBs) {
                Long appId;
                Optional appIdOptional = (Optional)appKey2IdCache.getUnchecked((Object)appKey);
                Long l = appId = appIdOptional.isPresent() ? (Long)appIdOptional.get() : null;
                if (null != appId && openBs && this.isAppDirectByAppId(appId).booleanValue()) {
                    this.consumerCookieDto = consumerFromWdata3;
                    this.removeWdata4Cookie();
                    if (this.consumerCookieDto != null && !appId.equals(this.consumerCookieDto.getAppId()) || this.consumerCookieDto == null) {
                        this.makeCommercialUser(appId);
                    }
                } else {
                    preferUseWdata4 = true;
                }
            } else {
                preferUseWdata4 = true;
            }
            if (preferUseWdata4) {
                this.consumerCookieDto = consumerFromWdata4 == null ? consumerFromWdata3 : consumerFromWdata4;
            }
            Long appId = null;
            if (this.consumerCookieDto != null) {
                appId = this.consumerCookieDto.getAppId();
            } else if (appKey != null) {
                Optional appIdOptional = (Optional)appKey2IdCache.getUnchecked((Object)appKey);
                Long l = appId = appIdOptional.isPresent() ? (Long)appIdOptional.get() : null;
            }
            if (appId != null && this.isAppForbidden(appId).booleanValue()) {
                RequestLocal.showForbiddenPage(response);
                return true;
            }
            return false;
        }

        private void removeWdata4Cookie() {
            Cookie[] cookies = this.request.getCookies();
            if (cookies == null || cookies.length == 0) {
                return;
            }
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("wdata4") && !cookie.getName().equals("w_ts")) continue;
                cookie.setValue("");
                cookie.setMaxAge(0);
                cookie.setDomain(cookieDomain);
                cookie.setPath("/");
                cookie.setHttpOnly(true);
                this.response.addCookie(cookie);
            }
        }

        private void makeCommercialUser(Long appId) {
            String uid = "gen_" + UUIDUtils.createUUID();
            ConsumerDto c = new ConsumerDto(true);
            c.setAppId(appId);
            c.setPartnerUserId(uid);
            ConsumerDto temp = remoteConsumerService.insert(c);
            c.setId(temp.getId());
            RequestLocal.injectConsumerInfoIntoCookie(c, true);
        }

        private Boolean isAppDirectByAppId(Long appId) {
            if (appId == null) {
                return false;
            }
            try {
                return (Boolean)appId2DirectCache.get((Object)appId);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private Boolean isAppForbidden(Long appId) {
            try {
                return (Boolean)appId2ForbidStatusCache.get((Object)appId);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private ConsumerCookieDto parseOldWdata3(boolean preferCookieForEver) {
            ConsumerDto consumer;
            ConsumerCookieDto c;
            String content;
            String wdata3 = RequestTool.getCookie((HttpServletRequest)this.request, (String)"wdata3");
            if (wdata3 == null || wdata3.isEmpty()) {
                return null;
            }
            try {
                content = BlowfishUtils.decryptBlowfish((String)wdata3, (String)oldConsumerEncryptKey);
                c = (ConsumerCookieDto)JSONObject.parseObject((String)content, ConsumerCookieDto.class);
            }
            catch (Exception e) {
                logger.error("wdata3:{}", (Object)wdata3, (Object)e);
                return null;
            }
            if (c.getAppId() == null) {
                logger.info("appId in wdata3 is null, wdata3:{},content:{}\uff0cset back", (Object)wdata3, (Object)content);
                if (c.getCid() != null && (consumer = remoteConsumerService.find(c.getCid())) != null) {
                    c.setAppId(consumer.getAppId());
                    if (needLogin && this.isAppDirectByAppId(c.getAppId()).booleanValue()) {
                        c.setForEver(true);
                        RequestLocal.injectConsumerInfoIntoCookie(consumer, true);
                    }
                }
            }
            if (c.isForEver()) {
                return c;
            }
            if (preferCookieForEver || this.isAppDirectByAppId(c.getAppId()).booleanValue()) {
                if (!c.isForEver()) {
                    c.setForEver(true);
                    consumer = new ConsumerDto();
                    consumer.setAppId(c.getAppId());
                    consumer.setPartnerUserId(c.getPartnerUserId());
                    consumer.setId(c.getCid());
                    if (needLogin) {
                        RequestLocal.injectConsumerInfoIntoCookie(consumer, true);
                    }
                }
                return c;
            }
            long now = System.currentTimeMillis();
            if (c.getTime() > now - 86400000L) {
                return c;
            }
            return null;
        }

        public ConsumerDto getConsumerDO() {
            if (this.consumerDO == null) {
                if (this.consumerCookieDto == null) {
                    return null;
                }
                ConsumerDto temp = new ConsumerDto();
                temp.setAppId(this.consumerCookieDto.getAppId());
                temp.setId(this.consumerCookieDto.getCid());
                temp.setPartnerUserId(this.consumerCookieDto.getPartnerUserId());
                ProxyFactory proxyFactory = new ProxyFactory();
                proxyFactory.setTarget((Object)temp);
                proxyFactory.addAdvice((Advice)new ConsumerMethodInterceptor(this));
                this.consumerDO = (ConsumerDto)proxyFactory.getProxy();
            }
            return this.consumerDO;
        }

        public ConsumerDto getConsumerAddr3DESDto() {
            ConsumerDto src = this.getConsumerDO();
            src.getAddrProvince();
            ConsumerDto consumerDto = new ConsumerDto();
            BeanUtils.copyProperties((Object)src, (Object)consumerDto);
            if (consumerDto != null) {
                if (StringUtils.isNotBlank((String)consumerDto.getAddrProvince())) {
                    consumerDto.setAddrProvince(DESCrypto.encrypt3DE(consumerDto.getAddrProvince().trim()));
                }
                if (StringUtils.isNotBlank((String)consumerDto.getAddrCity())) {
                    consumerDto.setAddrCity(DESCrypto.encrypt3DE(consumerDto.getAddrCity().trim()));
                }
                if (StringUtils.isNotBlank((String)consumerDto.getAddrArea())) {
                    consumerDto.setAddrArea(DESCrypto.encrypt3DE(consumerDto.getAddrArea().trim()));
                }
                if (StringUtils.isNotBlank((String)consumerDto.getAddrDetail())) {
                    consumerDto.setAddrDetail(DESCrypto.encrypt3DE(consumerDto.getAddrDetail().trim()));
                }
            }
            return consumerDto;
        }

        public AppSimpleDto getConsumerAppDO() {
            if (this.consumerAppDO == null) {
                if (this.consumerCookieDto == null) {
                    return null;
                }
                AppSimpleDto temp = new AppSimpleDto();
                temp.setId(this.consumerCookieDto.getAppId());
                ProxyFactory proxyFactory = new ProxyFactory();
                proxyFactory.setTarget((Object)temp);
                proxyFactory.addAdvice((Advice)new AppMethodInterceptor(this));
                this.consumerAppDO = (AppSimpleDto)proxyFactory.getProxy();
            }
            return this.consumerAppDO;
        }

        public HttpServletResponse getResponse() {
            if (this.response == null) {
                throw new IllegalStateException("response must not be null, please invoke RequestLocal.setThreadLocallyAndLimitQps first");
            }
            return this.response;
        }

        public HttpServletRequest getRequest() {
            if (this.request == null) {
                throw new IllegalStateException("request must not be null, please invoke RequestLocal.setThreadLocallyAndLimitQps first");
            }
            return this.request;
        }

        public String getTokenId() {
            return this.tokenId;
        }

        public String getDeap() {
            if (this.deap == null) {
                String[] deaps;
                String mdeap;
                String mdeapVal = RequestTool.getCookie((HttpServletRequest)this.request, (String)"deap");
                try {
                    mdeap = new String(BaseEncoding.base64Url().withPadChar('.').decode((CharSequence)mdeapVal), Charset.forName("utf-8"));
                }
                catch (Exception e) {
                    mdeap = mdeapVal;
                }
                if (StringUtils.isBlank((String)mdeap)) {
                    this.deap = "";
                    return null;
                }
                for (String requestStr : deaps = mdeap.split(",")) {
                    if (!requestStr.startsWith(this.getConsumerDO().getAppId() + "-")) continue;
                    this.deap = requestStr;
                    return this.deap;
                }
                if (this.deap == null) {
                    this.deap = "";
                }
            }
            return StringUtils.trimToNull((String)this.deap);
        }

        public boolean initAndLimitQpsForYjq(HttpServletRequest request, HttpServletResponse response) throws IOException {
            logger.info("yjq \u89e3\u6790cookie \u5f00\u59cb\u3002\u3002\u3002");
            this.request = request;
            this.response = response;
            ConsumerCookieDto consumerFromYjqInfo = null;
            try {
                consumerFromYjqInfo = duibaConsumerCookieClient.getConsumerCookieDtoForYjq(request);
            }
            catch (Exception e) {
                logger.info("get user from yjq_info error.", (Throwable)e);
            }
            String appKey = request.getParameter("appKey");
            this.consumerCookieDto = consumerFromYjqInfo;
            logger.info("yjq \u89e3\u6790cookie consumerFromYjqInfo={}", (Object)JSON.toJSONString((Object)consumerFromYjqInfo));
            Long appId = null;
            if (this.consumerCookieDto != null) {
                appId = this.consumerCookieDto.getAppId();
            } else if (appKey != null) {
                Optional appIdOptional = (Optional)appKey2IdCache.getUnchecked((Object)appKey);
                Long l = appId = appIdOptional.isPresent() ? (Long)appIdOptional.get() : null;
            }
            if (appId != null && this.isAppForbidden(appId).booleanValue()) {
                RequestLocal.showForbiddenPage(response);
                return true;
            }
            return false;
        }
    }
}

