/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.url.interceptor;

import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duiba.wolf.entity.Pair;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessFilter;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessLocal;
import cn.com.duibabiz.component.filters.bloom.url.factory.PathMapperFactory;
import cn.com.duibabiz.component.filters.bloom.url.path.PathMapping;
import cn.com.duibabiz.component.filters.bloom.url.path.PathParser;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class PathInterceptInterceptor
implements HandlerInterceptor {
    public static final Logger LOGGER = LoggerFactory.getLogger(PathInterceptInterceptor.class);
    @Resource
    private UrlSerialAccessFilter urlSerialAccessFilter;
    @Resource
    private PathMapperFactory pathMapperFactory;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Long cid = RequestLocal.getCid();
        String uri = request.getRequestURI();
        try {
            PathMapping pathMapping = (PathMapping)this.pathMapperFactory.getHandler(uri);
            if (pathMapping != null) {
                PathParser interceptPathParser = pathMapping.getInterceptPathParser();
                PathParser recordPathParser = pathMapping.getRecordPathParser();
                Pair<Boolean, String> pair = this.urlSerialAccessFilter.hasRecord(interceptPathParser, cid, recordPathParser.getPath());
                UrlSerialAccessLocal.set(pair);
            } else {
                LOGGER.info("urlSerialAccessService,intercept,pathMapping is NULL,cid={},path={},", (Object)cid, (Object)uri);
            }
        }
        catch (Exception e) {
            LOGGER.warn("urlSerialAccessService,intercept,exception,cid={},path={}", new Object[]{cid, uri, e});
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        UrlSerialAccessLocal.clear();
    }
}

