package cn.com.duiba.biz.tool.duiba.util;

import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duiba.geo.api.dto.IpAreaDto;
import cn.com.duiba.geo.api.remoteservice.RemoteIpAreaService;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.concurrent.ExecutorService;

/**
 * @author huakai
 * 通用风控inner工具类
 */
@Component
public class InnerLogTool implements ApplicationContextAware {

    private static Environment environment;

    private static RemoteIpAreaService remoteIpAreaService;

    private static ExecutorService executorService;


    private static Logger logger = LoggerFactory.getLogger ("innerLog");

    private static Logger application_logger = LoggerFactory.getLogger (InnerLogTool.class);


    public static ExecutorService executorService(){
        return executorService;
    }

    /**
     * 构建基础信息
     * @param log 日志内容
     * @param type 埋点类型
     * @return 日志json内容
     */
    private static JSONObject buildBasicInfo(JSONObject log, int type) {
        JSONObject json = new JSONObject();
        log.put("group", 2);
        log.put("type", type);
        log.put("time", DateUtils.getSecondStr(new Date()));
        log.put("json", json);
        return json;
    }

    /**
     * 构建请求信息
     * @param json 日志json内容
     */
    private static void buildRequestInfo(JSONObject json) {
        json.put ("consumerId", RequestLocal.getCid());
        json.put("appId", RequestLocal.getAppId());
        String ip = RequestLocal.getIp();
        json.put("ip", ip);
        if (StringUtils.isNotBlank(ip)) {
            IpAreaDto ipInfo = remoteIpAreaService.findIpInfo(ip);
            if (ipInfo != null){
                json.put("country",ipInfo.getCountry());
                json.put("province",ipInfo.getRegion());
                json.put("city",ipInfo.getCity());
            }
        }
        String userAgent = RequestLocal.getUserAgent();
        json.put("ua", userAgent);
        json.put("os", RequestTool.getOS (json.getString ("ua")));
    }

    /**
     * 构建系统西悉尼
     * @param json 日志json内容
     */
    private static void buildSysInfo(JSONObject json) {
        json.put("duibaPlatform",environment.getProperty("spring.application.name"));
    }

    /**
     * 构建uaInfo信息
     * @param uaInfo ua信息
     * @param json 日志json内容
     */
    private static void buildUaInfo(String uaInfo, JSONObject json) {
        if(StringUtils.isBlank(uaInfo)){
            json.putAll(JSONObject.parseObject(uaInfo));
        }
    }



    /**
     * 参与日志
     * @param activityType  活动类型
     * @param activityId    入库ID
     * @param id    活动那个ID
     */
    public static void joinInnerLog(Integer activityType, Long id, Long activityId,String uaInfo){
        executorService().execute(()->{
            JSONObject log = new JSONObject();
            JSONObject json = buildBasicInfo(log, 64);
            json.put("activityType", activityType);
            json.put("activityId", activityId);
            json.put("id", id);
            buildRequestInfo(json);
            buildSysInfo(json);
            buildUaInfo(uaInfo, json);
            logger.info(log.toJSONString());
        });
    }




    /**
     * 访问埋点
     * @param activityType 活动类型
     * @param id 活动id
     * @param activityId 引用活动id
     */
    public static void visitInnerLog(Integer activityType, Long id, Long activityId,String uaInfo){
        executorService().execute(()->{
            JSONObject log = new JSONObject();
            JSONObject json = buildBasicInfo(log, 92);

            json.put("activityType", activityType);
            json.put("activityId", activityId);
            json.put("id", id);
            buildRequestInfo(json);
            buildSysInfo(json);
            buildUaInfo(uaInfo, json);

            logger.info(log.toJSONString());
        });
    }

    /**
     * 兑换日志 76
     * @param activityType  活动类型
     * @param activityId    入库ID
     * @param id    活动那个ID
     * @param itemId 商品id 是appItemId
     * */
    public static void exchangeInnerLog(Integer activityType, Long id, Long activityId,Long itemId){
        executorService().execute(()->{
            JSONObject log = new JSONObject();
            JSONObject json = buildBasicInfo(log, 76);

            json.put("activityType", activityType);
            json.put("activityId", activityId);
            json.put("id", id);
            //看起来叫itemId，其实是appItemId
            json.put("itemId",itemId);
            buildRequestInfo(json);
            buildSysInfo(json);

            logger.info(log.toJSONString());
        });
    }


    /**
     * 助力日志 77
     * @param activityType  活动类型
     * @param activityId    入库ID
     * @param id    活动那个ID
     * @param assistedUserId 被助力用户cid
     * */
    public static void assistInnerLog(Integer activityType, Long id, Long activityId,Long assistedUserId,
                                      String uaInfo){
        executorService().execute(()->{
            JSONObject log = new JSONObject();
            JSONObject json = buildBasicInfo(log, 77);

            json.put("activityType", activityType);
            json.put("activityId", activityId);
            json.put("id", id);
            json.put("assistedUserId",assistedUserId);
            buildRequestInfo(json);
            buildSysInfo(json);
            buildUaInfo(uaInfo, json);
            logger.info(log.toJSONString());
        });
    }





    /**
     * 提现日志
     * @param activityType  活动类型
     * @param activityId    入库ID
     * @param id    活动那个ID
     * @param alipayAccount 支付宝账号
     * @param alipayName 支付宝实名认证姓名
     */
    public static void withdrawInnerLog(Integer activityType, Long id, Long activityId,
                                        String alipayAccount, String alipayName,String uaInfo){
        executorService().execute(()->{
            JSONObject log = new JSONObject();
            JSONObject json = buildBasicInfo(log, 65);

            json.put("activityType", activityType);
            json.put("activityId", activityId);
            json.put("id", id);
            json.put("alipayAccount", alipayAccount);
            json.put("alipayName", alipayName);
            buildRequestInfo(json);
            buildSysInfo(json);
            buildUaInfo(uaInfo, json);
            logger.info(log.toJSONString());
        });

    }

    /**
     * 领奖日志
     * @param activityType 活动类型
     * @param id 活动那个ID
     * @param ip ip
     * @param userAgent userAgent
     * @param appId 应用id
     * @param cid 用户id
     */
    public static void prizeRiskInnerLog(Integer activityType, Long id, Long activityId,String uaInfo, String ip, String userAgent, Long appId, Long cid){
        executorService().execute(()->{
            JSONObject log = new JSONObject();
            JSONObject json = new JSONObject();
            log.put ("group", 2);
            log.put("type", 71);
            log.put("time", DateUtils.getSecondStr(new Date()));
            log.put("json", json);
            json.put("activityType", activityType);
            json.put("activityId", activityId);
            json.put("id", id);
            json.put ("consumerId", cid);
            json.put("appId", appId);
            json.put("ip", ip);
            if (StringUtils.isNotBlank(ip)) {
                IpAreaDto ipInfo = remoteIpAreaService.findIpInfo(ip);
                if (ipInfo != null){
                    json.put("country",ipInfo.getCountry());
                    json.put("province",ipInfo.getRegion());
                    json.put("city",ipInfo.getCity());
                }
            }
            json.put("ua", userAgent);
            json.put("os", RequestTool.getOS (json.getString ("ua")));
            buildUaInfo(uaInfo, json);
            logger.info(log.toJSONString());
        });
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        environment = applicationContext.getBean(Environment.class);
        executorService = applicationContext.getBean(ExecutorService.class);
        remoteIpAreaService = applicationContext.getBean(RemoteIpAreaService.class);
    }
}
