package cn.com.duibabiz.component.token;

import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duibabiz.component.token.impl.TokenServiceImpl;
import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

/**
 * @author sty
 * @Version 1.0
 * @Date 11/20/18 09:51
 **/
@Configuration
@ConditionalOnProperty(name = "duiba.biztool.token.enable", havingValue = "true")
@AutoConfigureAfter(RedisAutoConfiguration.class)
@ConditionalOnClass({AdvancedCacheClient.class})
@ConditionalOnBean(name = "redisTemplate")
@EnableConfigurationProperties(TokenJsProperties.class)
public class TokenConfiguration {

	@Resource(name = "redisTemplate")
	private AdvancedCacheClient advancedCacheClient;
	@Autowired
	private TokenJsProperties tokenJsProperties;

	@Bean(name = "tokenCheckService")
	public TokenService tokenCheckService() {
		if (advancedCacheClient == null) {
			throw new IllegalArgumentException("advancedCacheClient注入失败");
		}
		return new TokenServiceImpl(advancedCacheClient, tokenJsProperties.getMultiDummyTokenJs());

	}


}
