package cn.com.duiba.biz.tool.duiba.client;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

/**
 * Created by Administrator on 2016/12/14.
 */
public final class DESCrypto {
	private static final Logger log = LoggerFactory.getLogger(DESCrypto.class);
	private static final String DES_KEY = "ZO-=/lFQhv0DjGph0TkuIqw+";
	private static final String TRIPLE_DES = "TripleDES";

	private static final String EOOERMSG = "Failed to encrypt3DE";

	/**
	 * 加密.
	 *
	 * @param source 明文
	 * @return 大写十六进制数
	 */
	public static String encrypt3DE(String source) {
		if (source == null) {
			return null;
		}
		try {
			SecretKeySpec spec = new SecretKeySpec(DES_KEY.getBytes(), "DESede");
			// Cipher对象实际完成加密操作
			Cipher cipher = Cipher.getInstance(TRIPLE_DES);
			// 用密匙初始化Cipher对象
			cipher.init(Cipher.ENCRYPT_MODE, spec);
			byte[] data = cipher.doFinal(URLEncoder.encode(source,"UTF-8").getBytes());
			return new String(Hex.encodeHex(data, false));
		} catch (GeneralSecurityException | IOException e) {
			log.error(EOOERMSG, e);
		}
		return null;
	}
	
	/**
	 * JS3DES解密
	 *
	 * @param key
	 * @throws InvalidKeyException
	 * @throws NoSuchAlgorithmException
	 * @throws IOException
	 */
	public static String decryptJS3DES(String key) {
		try {
			key = key.substring(2, key.length());
			String jsKey = DES_KEY;
			SecretKeySpec secretKeySpec = new SecretKeySpec(jsKey.getBytes(), TRIPLE_DES);
			// Cipher对象实际完成加密操作
			Cipher cipher = Cipher.getInstance(TRIPLE_DES);
			// 用密匙初始化Cipher对象
			cipher.init(Cipher.ENCRYPT_MODE, secretKeySpec);
			// 现在，获取数据并加密
			// 正式执行加密操作
			byte[] data = cipher.doFinal("        ".getBytes());
			String strRandom = new String(Hex.encodeHex(data, false));
			String strSuffix = strRandom.substring(strRandom.length() - 16);
			String cipherText = key.toUpperCase().substring(0, key.length() - 16) + strSuffix;
			Cipher newCipher = Cipher.getInstance(TRIPLE_DES);
			newCipher.init(Cipher.DECRYPT_MODE, secretKeySpec);
			byte[] result = newCipher.doFinal(Hex.decodeHex(cipherText.toCharArray()));
			return new String(result, "utf-8");
		} catch (GeneralSecurityException | DecoderException | IOException e) {
			log.error(EOOERMSG, e);
		}
		return null;
	}
}
