package cn.com.duiba.biz.tool.duiba.dto;

import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * request解析类 封装了request中的一些参数
 * 用于需要将ip、os、ua、transfer等request中的参数传递给异步线程或者center系统的场景
 */
public class RequestParams implements Serializable {

    private static final long serialVersionUID = -714078552503355128L;

    private static final String TRANSFER_KEY = "transfer";

    private String userAgent;
    private Long consumerId;
    private String ip;
    private String os;
    private String transfer;
    private String slotId;
    /** 是否代理流量 */
    private boolean proxy = false;
    private Map<String, String> cookies = new HashMap<>();
    private String deap;

    private RequestParams() {
    }

    public String getDeap() {
        return deap;
    }

    public void setDeap(String deap) {
        this.deap = deap;
    }

    public String getSlotId() {
        return slotId;
    }

    public void setSlotId(String slotId) {
        this.slotId = slotId;
    }

    public String getTransfer() {
        return transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public boolean isProxy() {
        return proxy;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public String getCookies(String name) {
        return this.cookies.get(name);
    }

    public Map<String, String> getCookies() {
        return cookies;
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public static RequestParams parse(HttpServletRequest request) {
        RequestParams rp = new RequestParams();
        rp.setUserAgent(request.getHeader("User-Agent"));
        rp.setIp(RequestTool.getIpAddr(request));
        rp.setConsumerId(RequestLocal.getCid());
        rp.parseCookies(request);
        rp.setOs(RequestTool.getOS(request));
        rp.setTransfer(getTransfer(request));
        rp.setSlotId(RequestTool.getCookie(request, "_coll_slot"));
        rp.setProxy(RequestTool.isProxy(request));
        rp.setDeap(RequestLocal.getDeap());
        return rp;
    }

    public static void getCookiesForMap(Map<String, String> cookies, Map<String, String> exposureNew) {
        //遍历Cookies中数据
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            if (entry.getKey().startsWith("_coll_")) {
                exposureNew.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private void parseCookies(HttpServletRequest request) {
        Cookie[] getCookies = request.getCookies();
        if (getCookies != null) {
            for (Cookie c : getCookies) {
                this.cookies.put(c.getName(), c.getValue());
            }
        }
    }

    private static String getTransfer(HttpServletRequest request) {
        if (StringUtils.isNotBlank(request.getParameter(TRANSFER_KEY))) {
            return request.getParameter(TRANSFER_KEY);
        }
        Cookie[] cs = request.getCookies();
        if (cs != null) {
            for (Cookie c : cs) {
                if (TRANSFER_KEY.equals(c.getName())) {
                    return c.getValue();
                }
            }
        }
        return null;
    }
}
