package cn.com.duiba.biz.tool.duiba.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 通知类型
 * @author zhangruofan
 * @date 2018/07/13
 */
public enum NotifyTypeEnum {
    NOTIFY_RESULT(0,"兑换结果通知"),
    NOTIFY_PAY(1,"支付结果通知"),
    NOTIFY_OBJECT_SEND(2, "实物订单发货通知");

    private Integer code;
    private String description;

    NotifyTypeEnum(Integer code, String description){
        this.code=code;
        this.description=description;
    }

    private static Map<Integer,NotifyTypeEnum> NOTIFY_MAP = Maps.newHashMap();
    static {
        for(NotifyTypeEnum notify:NotifyTypeEnum.values()){
            NOTIFY_MAP.put(notify.getCode(),notify);
        }
    }

    public static NotifyTypeEnum getByCode(Integer code) {
        //向上兼容
        if(code==null){
            return NotifyTypeEnum.NOTIFY_RESULT;
        }
        return NOTIFY_MAP.get(code);
    }
    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
