package cn.com.duiba.biz.tool.duiba.mq;

import cn.com.duiba.biz.tool.duiba.enums.NotifyTypeEnum;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Date;

/**
 * @author zhangruofan
 * @date 2018/07/13
 */
public class NotifyDeveloperMsgDto implements Serializable {
    private static final long serialVersionUID = -2102497700490097641L;
    private NotifyTypeEnum relationType;
    private Long relationId;
    private Long appId;
    private Long consumerId;
    private Boolean result;
    private Date nextTime;
    private Integer times;
    private String error4developer;
    private String developerBizId;
    private String duibaOrderNum;
    private String partnerUserId;
    private String transfer;
    private Integer notifyType;

    public NotifyTypeEnum getRelationType() {
        return relationType;
    }

    public void setRelationType(NotifyTypeEnum relationType) {
        this.relationType = relationType;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Boolean getResult() {
        return result;
    }

    public void setResult(Boolean result) {
        this.result = result;
    }

    public Date getNextTime() {
        return nextTime;
    }

    public void setNextTime(Date nextTime) {
        this.nextTime = nextTime;
    }

    public Integer getTimes() {
        return times;
    }

    public void setTimes(Integer times) {
        this.times = times;
    }

    public String getError4developer() {
        return error4developer;
    }

    public void setError4developer(String error4developer) {
        this.error4developer = error4developer;
    }

    public String getDeveloperBizId() {
        return developerBizId;
    }

    public void setDeveloperBizId(String developerBizId) {
        this.developerBizId = developerBizId;
    }

    public String getDuibaOrderNum() {
        return duibaOrderNum;
    }

    public void setDuibaOrderNum(String duibaOrderNum) {
        this.duibaOrderNum = duibaOrderNum;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public String getTransfer() {
        return transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }

    public Integer getNotifyType() {
        return notifyType;
    }

    public void setNotifyType(Integer notifyType) {
        this.notifyType = notifyType;
    }

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static NotifyDeveloperMsgDto decode(byte[] msg) {
        String body = new String(msg, Charset.forName("utf-8"));
        return JSONObject.parseObject(body, NotifyDeveloperMsgDto.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param notifyDeveloperMsg
     * @return
     */
    public static byte[] encode(NotifyDeveloperMsgDto notifyDeveloperMsg) {
        String string = JSONObject.toJSONString(notifyDeveloperMsg);
        return string.getBytes(Charset.forName("utf-8"));
    }
}
