package cn.com.duibabiz.component.filters.bloom.url;

import cn.com.duibabiz.component.filters.bloom.daily.BasicConConfig;
import cn.com.duibabiz.component.filters.bloom.url.factory.PathMapperFactory;
import cn.com.duibabiz.component.filters.bloom.url.factory.PathParserFactory;
import cn.com.duibabiz.component.filters.bloom.url.interceptor.PathInterceptInterceptor;
import cn.com.duibabiz.component.filters.bloom.url.interceptor.PathMvcConfig;
import cn.com.duibabiz.component.filters.bloom.url.interceptor.PathRecordInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;

/**
 * 自动配置
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/4/15 20:58
 */
@Order()
@Configuration
@ConditionalOnWebApplication
@Import({PathMvcConfig.class, BasicConConfig.class})
public class DefaultBeanConfig implements InitializingBean {
    public static final Logger LOGGER = LoggerFactory.getLogger(DefaultBeanConfig.class);

    @Bean
    public PathParserFactory pathStrategyFactory() {
        return new PathParserFactory();
    }

    @Bean
    public PathMapperFactory pathMapperFactory() {
        return new PathMapperFactory();
    }

    @Bean
    public PathInterceptInterceptor pathInterceptInterceptor() {
        return new PathInterceptInterceptor();
    }

    @Bean
    public PathRecordInterceptor pathRecordInterceptor() {
        return new PathRecordInterceptor();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        LOGGER.info("接口顺序访问一揽子自动配置加载完毕");
    }
}
