package cn.com.duibabiz.component.filters.bloom.url.factory;

import cn.com.duibabiz.component.filters.bloom.url.path.PathMapping;
import cn.com.duibabiz.tools.strategy.AbstractStrategyFactory;

import javax.annotation.Resource;
import java.util.HashSet;
import java.util.Set;

/**
 * 自动注册PathMapper
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/4/16 18:28
 */
public class PathMapperFactory extends AbstractStrategyFactory<String, PathMapping> {

    @Resource
    private PathParserFactory pathParserFactory;

    /**
     * 每个处理器的唯一key
     *
     * @param pathMapping
     */
    @Override
    protected String getKey(PathMapping pathMapping) {
        return pathMapping.getInterceptPathParser().getPath();
    }

    /**
     * 注册
     *
     * @param pathMapping
     */
    @Override
    public void registry(PathMapping pathMapping) {
        super.registry(pathMapping);

        // 注册到PathParserFactory
        pathParserFactory.registry(pathMapping.getInterceptPathParser());
        pathParserFactory.registry(pathMapping.getRecordPathParser());
    }

    /**
     * 获取所有需要记录的path
     */
    public Set<String> getRecordPaths() {
        Set<String> recordPaths = new HashSet<>();
        for (String key : getKeySet()) {
            PathMapping handler = getHandler(key);

            String path = handler.getRecordPathParser().getPath();
            recordPaths.add(path);
        }
        return recordPaths;
    }
}
