/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.tool.duiba.client;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    private static final String DAY = "yyyy-MM-dd";
    private static final String MONTH = "yyyy-MM";

    private DateUtils() {
    }

    public static LocalDate getLastDayOfMonth(LocalDate localDate) {
        return localDate.withDayOfMonth(localDate.lengthOfMonth());
    }

    public static LocalDate getLastDayOfWeek(LocalDate localDate) {
        return localDate.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
    }

    public static Date getDayDate(String dateStr) {
        return DateUtils.getDate(dateStr, new SimpleDateFormat(DAY));
    }

    private static Date getDate(String dateStr, SimpleDateFormat format) {
        if ("".equals(dateStr) || dateStr == null) {
            return null;
        }
        try {
            return format.parse(dateStr);
        }
        catch (ParseException e) {
            log.error("format yyyy-MM-dd HH:mm:ss error:", (Throwable)e);
            return null;
        }
    }

    public static long timeDifferenceSeconds(String dataStr, String dateFormat) {
        Calendar curDate = Calendar.getInstance();
        Calendar toDate = Calendar.getInstance();
        try {
            toDate.setTime(new SimpleDateFormat(dateFormat).parse(dataStr));
        }
        catch (ParseException e) {
            return 0L;
        }
        GregorianCalendar toDateNew = new GregorianCalendar(toDate.get(1), toDate.get(2), toDate.get(5) + 1, 0, 0, 0);
        return (toDateNew.getTimeInMillis() - curDate.getTimeInMillis()) / 1000L;
    }

    public static int getToTomorrowSeconds() {
        Calendar curDate = Calendar.getInstance();
        GregorianCalendar tommorowDate = new GregorianCalendar(curDate.get(1), curDate.get(2), curDate.get(5) + 1, 0, 0, 0);
        return Math.max((int)((tommorowDate.getTimeInMillis() - curDate.getTimeInMillis()) / 1000L), 1);
    }

    public static String nextDay(int day) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, day);
        Date next = c.getTime();
        return new SimpleDateFormat(DAY).format(next);
    }

    public static String getLastOfWeek() {
        Calendar cal = Calendar.getInstance();
        int d = cal.get(7) == 1 ? 0 : 8 - cal.get(7);
        cal.add(7, d);
        return new SimpleDateFormat(DAY).format(cal.getTime());
    }

    public static String getLastOfMonth() {
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        return new SimpleDateFormat(DAY).format(ca.getTime());
    }

    public static Date getFistDayOfMonth() {
        Calendar ca = Calendar.getInstance();
        ca.add(2, 0);
        ca.set(5, 1);
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        return ca.getTime();
    }

    public static int timeDifferenceMonth(Date timeStar, Date timeEnd) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(timeStar);
        int yearStat = ca.get(1);
        int monStat = ca.get(2) + 1;
        ca.setTime(timeEnd);
        int monEnd = ca.get(2) + 1;
        int yearEnd = ca.get(1);
        return (yearEnd - yearStat) * 12 + monEnd - monStat;
    }

    public static String getYYYYMM(Date time) {
        SimpleDateFormat sf = new SimpleDateFormat(MONTH);
        Calendar ca = Calendar.getInstance();
        ca.setTime(time);
        ca.add(2, -1);
        return sf.format(ca.getTime());
    }

    public static int getWeekOfYear(Date time) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(time);
        return ca.get(3);
    }

    public static String getDayStr(Date date) {
        return DateUtils.getStr(date, new SimpleDateFormat(DAY));
    }

    private static String getStr(Date date, SimpleDateFormat format) {
        if (date == null) {
            return "";
        }
        return format.format(date);
    }
}

