/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.tool.duiba.util;

import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duiba.wolf.utils.SecurityUtils;
import java.util.stream.IntStream;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuibaTokenUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuibaTokenUtil.class);
    private static final int TOKEN_MIN_LENGTH = 5;
    private static final int TOKEN_RANDOM_RANGE_EXCLUSIVE = 5;
    private static final String RANDOM_STRING_BASE = "abcdefghijklmnopqrstuvwxyz0123456789";
    private static final String ERROR_SECRET_TOKEN_KEY = "uiiosaidnbua";
    private static final String TOKEN_KEY_START = "t";
    private static final int TOKEN_KEY_LENGTH = 8;
    private static final int DUMMY_TOKEN_RANGE_EXCLUSIVE = 10000000;

    public static String genToken() {
        return DuibaTokenUtil.getRandomString(5 + RandomUtils.nextInt((int)5));
    }

    public static String getSecretTokenKey(Long consumerId) {
        return DuibaTokenUtil.getTokenKey(String.valueOf(consumerId));
    }

    public static String getSecretTokenKey() {
        return DuibaTokenUtil.getSecretTokenKey(RequestLocal.getCid());
    }

    public static String genDummyTokenKey() {
        return DuibaTokenUtil.getTokenKey("0" + RandomUtils.nextInt((int)10000000));
    }

    private static String getTokenKey(String val) {
        if (val == null) {
            return ERROR_SECRET_TOKEN_KEY;
        }
        try {
            String md5 = SecurityUtils.encode2StringByMd5((String)val);
            return TOKEN_KEY_START + md5.substring(md5.length() - (8 - TOKEN_KEY_START.length()));
        }
        catch (Exception e) {
            LOGGER.warn("\u83b7\u53d6key\u5931\u8d25\uff0cval={}", (Object)val, (Object)e);
            return ERROR_SECRET_TOKEN_KEY;
        }
    }

    private static String getRandomString(int length) {
        StringBuilder sb = new StringBuilder();
        IntStream.range(0, length).forEach(i -> sb.append(RANDOM_STRING_BASE.charAt(RandomUtils.nextInt((int)RANDOM_STRING_BASE.length()))));
        return sb.toString();
    }
}

