/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.basic;

import com.google.common.base.Charsets;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;

public class BloomFilterConfig {
    private final int numHashFunctions;
    private final int bitSize;
    private static final Funnel<CharSequence> FUNNEL = Funnels.stringFunnel((Charset)Charsets.UTF_8);
    private final int growBuffer;
    private final int expectedInsertions;
    private final double fpp;

    public BloomFilterConfig(int growBuffer, int expectedInsertions, double fpp) {
        this.growBuffer = growBuffer;
        this.expectedInsertions = expectedInsertions;
        this.fpp = fpp;
        this.bitSize = BloomFilterConfig.optimalNumOfBits(expectedInsertions, fpp);
        this.numHashFunctions = BloomFilterConfig.optimalNumOfHashFunctions(expectedInsertions, this.bitSize);
    }

    public int getNumHashFunctions() {
        return this.numHashFunctions;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    int[] murmurHashOffset(String value) {
        int[] offset = new int[this.numHashFunctions];
        long hash64 = Hashing.murmur3_128().hashObject((Object)value, FUNNEL).asLong();
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int nextHash = hash1 + i * hash2;
            if (nextHash < 0) {
                nextHash ^= 0xFFFFFFFF;
            }
            offset[i - 1] = nextHash % this.bitSize;
        }
        return offset;
    }

    private static int optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (int)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    private static int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)m / (double)n * Math.log(2.0)));
    }

    public int getGrowBuffer() {
        return this.growBuffer;
    }

    public int getExpectedInsertions() {
        return this.expectedInsertions;
    }

    public double getFpp() {
        return this.fpp;
    }
}

