/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters.bloom.url.interceptor;

import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duibabiz.component.filters.bloom.url.UrlSerialAccessFilter;
import cn.com.duibabiz.component.filters.bloom.url.factory.PathParserFactory;
import cn.com.duibabiz.component.filters.bloom.url.path.PathParser;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class PathRecordInterceptor
implements HandlerInterceptor {
    public static final Logger LOGGER = LoggerFactory.getLogger(PathRecordInterceptor.class);
    @Resource
    private UrlSerialAccessFilter urlSerialAccessFilter;
    @Resource
    private PathParserFactory pathParserFactory;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Long cid = RequestLocal.getCid();
        String uri = request.getRequestURI();
        try {
            PathParser pathParser = (PathParser)this.pathParserFactory.getHandler(uri);
            if (pathParser != null) {
                this.urlSerialAccessFilter.record(pathParser, cid);
            } else {
                LOGGER.warn("urlSerialAccessService,record,pathParser is NULL,cid={},path={}", (Object)cid, (Object)uri);
            }
        }
        catch (Exception e) {
            LOGGER.warn("urlSerialAccessService,record,exception,cid={},path={}", new Object[]{cid, uri, e});
        }
    }
}

