package cn.com.duibabiz.component.domain.impl;

import cn.com.duiba.developer.center.api.domain.dto.DomainConfigDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteDomainConfigService;
import cn.com.duibabiz.component.domain.DomainService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.TimeUnit;

/**
 * Created by zzy on  2018/09/28 20:48
 */
public class DomainServiceImpl implements DomainService {
    private static Logger logger = LoggerFactory.getLogger(DomainServiceImpl.class);
    private final RemoteDomainConfigService remoteDomainConfigService;
    private final String serviceDomain;

    private final String tuiaDomain;

    private final String cdnDomain;

    public DomainServiceImpl(RemoteDomainConfigService remoteDomainConfigService, String serviceDomain, String tuiaDomain, String cdnDomain) {
        this.remoteDomainConfigService = remoteDomainConfigService;
        this.serviceDomain = serviceDomain;
        this.tuiaDomain = tuiaDomain;
        this.cdnDomain = cdnDomain;
    }

    private static final Cache<Long, DomainConfigDto> LOCAL_DOMAIN_CACHE = CacheBuilder.newBuilder().expireAfterWrite(3, TimeUnit.MINUTES).maximumSize(1000).build();

    @Override
    public DomainConfigDto getSystemDomain(Long appId) {
        DomainConfigDto domainConfigDto = null;
        //尝试获取本地缓存
        if (appId == null) {
            appId = -1L;
        }

        DomainConfigDto cache = getCache(appId);
        if (cache != null) {
            return cache;
        }
        try {
            domainConfigDto = remoteDomainConfigService.findDomainConfig(appId).getResult();
        } catch (Exception e) {
            logger.error("根据appid查找域名失败{}", appId, e);
        }
        //本处将本工程需要的域名封装进dto
        if (domainConfigDto == null) {
            domainConfigDto = getLocalDomain();
            logger.warn("retrieve local domain, appId:{}, domain: {}", appId, JSONObject.toJSONString(domainConfigDto));
        }
        LOCAL_DOMAIN_CACHE.put(appId, domainConfigDto);
        return domainConfigDto;
    }

    private DomainConfigDto getLocalDomain() {
        DomainConfigDto domainConfigDto = new DomainConfigDto();
        domainConfigDto.setAppDomain(serviceDomain);
        domainConfigDto.setEmbedDomain(serviceDomain);
        domainConfigDto.setSeckillDomain(serviceDomain);
        domainConfigDto.setGoodsDomain(serviceDomain);
        domainConfigDto.setHomeDomain(serviceDomain);
        domainConfigDto.setActivityDomain(serviceDomain);
        domainConfigDto.setTradeDomain(serviceDomain);
        domainConfigDto.setTuiaDomain(tuiaDomain);
        domainConfigDto.setCdnDomain(cdnDomain);
        return domainConfigDto;
    }

    private DomainConfigDto getCache(Long key) {
        return key != null ? LOCAL_DOMAIN_CACHE.getIfPresent(key) : null;
    }
}
