/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.tool.duiba.util;

import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duiba.biz.tool.duiba.dto.RequestLocalParam;
import cn.com.duiba.biz.tool.duiba.util.SpringUtil;
import cn.com.duiba.geo.api.dto.IpAreaDto;
import cn.com.duiba.geo.api.remoteservice.RemoteIpAreaService;
import cn.com.duiba.tuia.union.star.center.api.cache.service.RemoteDeviceUaParseCache;
import cn.com.duiba.tuia.union.star.center.api.remoteservice.domain.rsp.MobileUaInfoDTO;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class InnerLogTool {
    private static Environment environment;
    private static String APPLICATION_NAME;
    private static RemoteIpAreaService remoteIpAreaService;
    private static RemoteDeviceUaParseCache remoteDeviceUaParseCache;
    private static final ExecutorService executorService;
    private static final Logger logger;
    private static final Logger APPLICATION_LOGGER;

    public static Environment environment() {
        if (environment == null) {
            environment = SpringUtil.getBean(Environment.class);
        }
        return environment;
    }

    public static RemoteIpAreaService remoteIpAreaService() {
        if (remoteIpAreaService == null) {
            remoteIpAreaService = SpringUtil.getBean(RemoteIpAreaService.class);
        }
        return remoteIpAreaService;
    }

    public static RemoteDeviceUaParseCache remoteDeviceUaParseCache() {
        if (remoteDeviceUaParseCache == null) {
            remoteDeviceUaParseCache = SpringUtil.getBean(RemoteDeviceUaParseCache.class);
        }
        return remoteDeviceUaParseCache;
    }

    public static ExecutorService executorService() {
        return executorService;
    }

    public static String applicationName() {
        if (StringUtils.isBlank((CharSequence)APPLICATION_NAME)) {
            APPLICATION_NAME = InnerLogTool.environment().getProperty("spring.application.name");
        }
        return APPLICATION_NAME;
    }

    private static JSONObject buildBasicInfo(JSONObject log, int type) {
        JSONObject json = new JSONObject();
        log.put("group", (Object)2);
        log.put("type", (Object)type);
        log.put("time", (Object)DateUtils.getSecondStr((Date)new Date()));
        log.put("json", (Object)json);
        return json;
    }

    private static void buildRequestInfo(JSONObject json, RequestLocalParam requestLocalMessage) {
        IpAreaDto ipInfo;
        json.put("consumerId", (Object)requestLocalMessage.getConsumerId());
        json.put("appId", (Object)requestLocalMessage.getAppId());
        String ip = requestLocalMessage.getIp();
        json.put("ip", (Object)ip);
        if (StringUtils.isNotBlank((CharSequence)ip) && (ipInfo = InnerLogTool.getIpInfo(ip)) != null) {
            json.put("country", (Object)ipInfo.getCountry());
            json.put("province", (Object)ipInfo.getRegion());
            json.put("city", (Object)ipInfo.getCity());
        }
        String userAgent = requestLocalMessage.getUserAgent();
        json.put("ua", (Object)userAgent);
        json.put("os", (Object)RequestTool.getOS((String)json.getString("ua")));
    }

    private static void buildSysInfo(JSONObject json) {
        json.put("duibaPlatform", (Object)InnerLogTool.applicationName());
    }

    private static void buildExtraInfo(String extraInfo, JSONObject json) {
        if (StringUtils.isNotBlank((CharSequence)extraInfo)) {
            json.putAll((Map)JSONObject.parseObject((String)extraInfo));
        }
    }

    public static void buildUaInfo(RequestLocalParam requestLocalParam, JSONObject json) {
        MobileUaInfoDTO uaInfo;
        String userAgent;
        if (json != null && StringUtils.isNotBlank((CharSequence)(userAgent = requestLocalParam.getUserAgent())) && (uaInfo = InnerLogTool.getUAInfo(userAgent)) != null) {
            json.putAll((Map)JSONObject.parseObject((String)JSON.toJSONString((Object)uaInfo)));
        }
    }

    public static RequestLocalParam buildDefaultRequestLocalMessage() {
        RequestLocalParam requestLocalParam = new RequestLocalParam();
        requestLocalParam.setIp(RequestLocal.getIp());
        requestLocalParam.setConsumerId(RequestLocal.getCid());
        requestLocalParam.setAppId(RequestLocal.getAppId());
        requestLocalParam.setUserAgent(RequestLocal.getUserAgent());
        return requestLocalParam;
    }

    public static void innerLog(RequestLocalParam requestLocalParam, Integer logType, Integer activityType, Long id, Long activityId, String extraInfo) {
        InnerLogTool.executorService().execute(() -> {
            JSONObject log = new JSONObject();
            JSONObject json = InnerLogTool.buildBasicInfo(log, logType);
            if (activityType != null) {
                json.put("activityType", (Object)activityType);
            }
            if (activityType != null) {
                json.put("activityId", (Object)activityId);
            }
            if (id != null) {
                json.put("id", (Object)id);
            }
            InnerLogTool.buildRequestInfo(json, requestLocalParam);
            InnerLogTool.buildUaInfo(requestLocalParam, json);
            InnerLogTool.buildSysInfo(json);
            InnerLogTool.buildExtraInfo(extraInfo, json);
            logger.info(log.toJSONString());
        });
    }

    public static IpAreaDto getIpInfo(String ip) {
        IpAreaDto ipInfo = null;
        try {
            ipInfo = InnerLogTool.remoteIpAreaService().findIpInfo(ip);
        }
        catch (Exception e) {
            APPLICATION_LOGGER.warn("ip\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        return ipInfo;
    }

    public static MobileUaInfoDTO getUAInfo(String ua) {
        MobileUaInfoDTO mobileInfoByUa = null;
        if (StringUtils.isBlank((CharSequence)ua)) {
            return null;
        }
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ua})) {
                mobileInfoByUa = InnerLogTool.remoteDeviceUaParseCache().getMobileInfoByUa(ua);
            }
        }
        catch (Exception e) {
            APPLICATION_LOGGER.warn("ua\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        return mobileInfoByUa;
    }

    static {
        executorService = new ThreadPoolExecutor(30, 30, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(5000), new ThreadFactory(){
            int i = 1;

            @Override
            public Thread newThread(@NotNull Runnable r) {
                return new Thread(r, "InnerLogTool-" + this.i++);
            }
        }, new ThreadPoolExecutor.AbortPolicy());
        logger = LoggerFactory.getLogger((String)"innerLog");
        APPLICATION_LOGGER = LoggerFactory.getLogger(InnerLogTool.class);
    }
}

